/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.clientadapter.Activator;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNClientManager {
    private String svnClientInterface;
    private String svnAdminDir = ".svn";
    private File configDir = null;
    private boolean fetchChangePathOnDemand = true;
    private HashMap clients = new HashMap();
    public static final String UNABLE_TO_LOAD_DEFAULT_CLIENT = "Unable to load default SVN Client";

    public void startup(IProgressMonitor monitor) throws CoreException {
    }

    public void shutdown(IProgressMonitor monitor) throws CoreException {
    }

    public void setSvnClientInterface(String svnClientInterface) {
        this.svnClientInterface = svnClientInterface;
    }

    public String getSvnClientInterface() {
        return this.svnClientInterface;
    }

    public String getSvnAdminDirectory() {
        return this.svnAdminDir;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
        Set keys = this.clients.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ISVNClientAdapter svnClient = (ISVNClientAdapter)this.clients.get(key);
            if (svnClient == null) continue;
            try {
                svnClient.setConfigDirectory(configDir);
            }
            catch (SVNClientException sVNClientException) {
                break;
            }
        }
    }

    public ISVNClientAdapter getSVNClient() throws SVNException {
        ISVNClientAdapter svnClient = this.getAdapter(this.svnClientInterface);
        if (svnClient == null) {
            svnClient = this.getAdapter(null);
        }
        if (svnClient == null) {
            throw new SVNException("No client adapters available.");
        }
        return svnClient;
    }

    public ISVNClientAdapter createSVNClient() throws SVNException {
        ISVNClientAdapter svnClient = this.getAdapter(this.svnClientInterface);
        svnClient = Activator.getDefault().getClientAdapter(this.svnClientInterface);
        if (svnClient == null && (svnClient = Activator.getDefault().getAnyClientAdapter()) == null) {
            throw new SVNException("No client adapters available.");
        }
        this.setupClientAdapter(svnClient);
        return svnClient;
    }

    private void setupClientAdapter(ISVNClientAdapter svnClient) throws SVNException {
        if (this.configDir != null) {
            try {
                svnClient.setConfigDirectory(this.configDir);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        if (SVNProviderPlugin.getPlugin().getSvnPromptUserPassword() != null) {
            svnClient.addPasswordCallback(SVNProviderPlugin.getPlugin().getSvnPromptUserPassword());
        }
        this.svnAdminDir = svnClient.getAdminDirectoryName();
    }

    private ISVNClientAdapter getAdapter(String key) throws SVNException {
        ISVNClientAdapter client = null;
        if (key == null) {
            key = "default";
        }
        if ((client = (ISVNClientAdapter)this.clients.get(key)) == null) {
            if (!key.equals("default")) {
                client = Activator.getDefault().getClientAdapter(this.svnClientInterface);
            }
            if (client == null) {
                client = Activator.getDefault().getAnyClientAdapter();
            }
            if (client == null) {
                throw new SVNException(UNABLE_TO_LOAD_DEFAULT_CLIENT);
            }
            this.setupClientAdapter(client);
            if (client.isThreadsafe()) {
                this.clients.put(key, client);
            }
        }
        return client;
    }

    public boolean isFetchChangePathOnDemand() {
        return this.fetchChangePathOnDemand;
    }

    public void setFetchChangePathOnDemand(boolean fetchChangePathOnDemand) {
        this.fetchChangePathOnDemand = fetchChangePathOnDemand;
    }
}

