/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.history;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.PlatformObject;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class LogEntry
extends PlatformObject
implements ILogEntry {
    private ISVNRemoteResource remoteResource;
    private ISVNLogMessage logMessage;
    private ISVNResource resource;
    private Alias[] tags;
    private String messageOverride = null;
    private String authorOverride = null;
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    private LogEntry(ISVNLogMessage logMessage, ISVNResource resource, ISVNRemoteResource remoteResource, Alias[] tags) {
        this.logMessage = logMessage;
        this.remoteResource = remoteResource;
        this.resource = resource;
        this.tags = tags;
    }

    public static ILogEntry[] createLogEntriesFrom(ISVNRemoteFolder remoteFolder, ISVNLogMessage[] logMessages, Tags[] tags) {
        ILogEntry[] result = new ILogEntry[logMessages.length];
        int i = 0;
        while (i < logMessages.length) {
            result[i] = new LogEntry(logMessages[i], remoteFolder, null, tags[i] != null ? tags[i].getTags() : null);
            ++i;
        }
        return result;
    }

    public static ILogEntry[] createLogEntriesFrom(ISVNRemoteFile remoteFile, ISVNLogMessage[] logMessages, Tags[] tags, SVNUrl[] urls) {
        ILogEntry[] result = new ILogEntry[logMessages.length];
        int i = 0;
        while (i < logMessages.length) {
            ISVNLogMessage logMessage = logMessages[i];
            RemoteFile correspondingResource = new RemoteFile(null, remoteFile.getRepository(), urls[i], (SVNRevision)logMessage.getRevision(), logMessage.getRevision(), logMessage.getDate(), logMessage.getAuthor());
            result[i] = new LogEntry(logMessage, remoteFile, correspondingResource, tags[i] != null ? tags[i].getTags() : null);
            ++i;
        }
        return result;
    }

    public SVNRevision.Number getRevision() {
        return this.logMessage.getRevision();
    }

    public String getAuthor() {
        if (this.authorOverride != null) {
            return this.authorOverride;
        }
        return this.logMessage.getAuthor();
    }

    public Date getDate() {
        return this.logMessage.getDate();
    }

    public String getComment() {
        if (this.messageOverride != null) {
            return this.messageOverride;
        }
        if (this.logMessage.getMessage() == null) {
            return "";
        }
        return this.logMessage.getMessage();
    }

    public ISVNResource getResource() {
        return this.resource;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.remoteResource;
    }

    public LogEntryChangePath[] getLogEntryChangePaths() {
        ISVNLogMessageChangePath[] changePaths = null;
        if (SVNProviderPlugin.getPlugin().getSVNClientManager().isFetchChangePathOnDemand()) {
            SVNUrl url = this.resource.getRepository().getRepositoryRoot();
            if (url == null) {
                url = this.updateRootUrl(this.resource);
            }
            if ((changePaths = this.getPathsOnDemand(url)) == null) {
                SVNUrl url2 = this.updateRootUrl(this.resource);
                if (!url.toString().equals(url2.toString())) {
                    changePaths = this.getPathsOnDemand(url);
                }
                if (changePaths == null) {
                    changePaths = this.getPathsOnDemand(this.resource.getUrl());
                }
                if (changePaths == null) {
                    changePaths = new ISVNLogMessageChangePath[]{};
                }
            }
        } else {
            changePaths = this.logMessage.getChangedPaths();
        }
        LogEntryChangePath[] logEntryChangePaths = new LogEntryChangePath[changePaths.length];
        int i = 0;
        while (i < changePaths.length) {
            logEntryChangePaths[i] = new LogEntryChangePath(this, changePaths[i]);
            ++i;
        }
        return logEntryChangePaths;
    }

    private SVNUrl updateRootUrl(ISVNResource resource) {
        try {
            ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClient();
            SVNProviderPlugin.disableConsoleLogging();
            ISVNInfo info = client.getInfo(resource.getUrl());
            SVNProviderPlugin.enableConsoleLogging();
            if (info.getRepository() == null) {
                return resource.getUrl();
            }
            resource.getRepository().setRepositoryRoot(info.getRepository());
            return info.getRepository();
        }
        catch (Exception exception) {
            SVNProviderPlugin.enableConsoleLogging();
            return resource.getUrl();
        }
    }

    private ISVNLogMessageChangePath[] getPathsOnDemand(SVNUrl url) {
        try {
            ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClient();
            SVNProviderPlugin.disableConsoleLogging();
            ISVNLogMessage[] tmpMessage = client.getLogMessages(url, (SVNRevision)this.getRevision(), (SVNRevision)this.getRevision(), true);
            SVNProviderPlugin.enableConsoleLogging();
            if (tmpMessage != null && tmpMessage.length > 0) {
                return tmpMessage[0].getChangedPaths();
            }
            return null;
        }
        catch (Exception exception) {
            SVNProviderPlugin.enableConsoleLogging();
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.remoteResource)) {
            return this.remoteResource;
        }
        return super.getAdapter(adapter);
    }

    public void setComment(String newComment) {
        this.messageOverride = newComment;
    }

    public void setAuthor(String newAuthor) {
        this.authorOverride = newAuthor;
    }

    public Alias[] getTags() {
        return this.tags;
    }

    public void setTags(Alias[] tags) {
        this.tags = tags;
    }

    public long getNumberOfChildren() {
        return this.logMessage.getNumberOfChildren();
    }

    public ILogEntry[] getChildMessages() {
        ISVNLogMessage[] childMessages = this.logMessage.getChildMessages();
        if (childMessages == null) {
            return null;
        }
        ILogEntry[] childEntries = new ILogEntry[childMessages.length];
        int i = 0;
        while (i < childMessages.length) {
            childEntries[i] = new LogEntry(childMessages[i], this.resource, this.remoteResource, null);
            ++i;
        }
        return childEntries;
    }

    public String getMergedRevisionsAsString() {
        ILogEntry[] childMessages = this.getChildMessages();
        if (childMessages == null || childMessages.length == 0) {
            return "";
        }
        StringBuffer mergedRevisions = new StringBuffer();
        int i = 0;
        while (i < childMessages.length) {
            if (i > 0) {
                mergedRevisions.append(", ");
            }
            mergedRevisions.append(childMessages[i].getRevision().getNumber());
            ++i;
        }
        return mergedRevisions.toString();
    }

    public String getChangeLog(boolean includeAffectedPaths) {
        StringBuffer log = new StringBuffer("r" + this.getRevision());
        if (this.getAuthor() != null) {
            log.append(" | " + this.getAuthor());
        }
        if (this.getDate() != null) {
            log.append(" | " + this.formatDate());
        }
        if (includeAffectedPaths) {
            log.append("\nChanged paths:");
            LogEntryChangePath[] changePaths = this.getLogEntryChangePaths();
            int i = 0;
            while (i < changePaths.length) {
                log.append("\n\t" + changePaths[i].getAction() + " " + changePaths[i].getPath());
                ++i;
            }
        }
        if (this.getComment() != null && this.getComment().trim().length() > 0) {
            log.append("\n\n" + this.getComment());
        }
        log.append("\n----------------------------------------------------------------------------\n");
        return log.toString();
    }

    public String getGnuLog() {
        StringBuffer log = new StringBuffer();
        if (this.getDate() != null) {
            log.append(this.formatDate());
        }
        if (this.getAuthor() != null) {
            log.append("  " + this.getAuthor());
        }
        if (this.getComment() != null && this.getComment().trim().length() > 0) {
            String tabbedComment = "\t" + this.getComment().replaceAll("\n", "\n\t");
            log.append("\n\n" + tabbedComment);
        }
        log.append("\n\n");
        return log.toString();
    }

    private String formatDate() {
        return format.format(this.getDate());
    }
}

