/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNConflictVersion;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class ResourceStatus
implements ISVNStatus,
Serializable {
    static final long serialVersionUID = 1L;
    protected static final int FORMAT_VERSION_1 = 1;
    protected static final int FORMAT_VERSION_2 = 2;
    protected static final int FORMAT_VERSION_3 = 3;
    protected static final int FORMAT_VERSION_4 = 4;
    protected String url;
    protected File file;
    protected long lastChangedRevision;
    protected long lastChangedDate;
    protected String lastCommitAuthor;
    protected int textStatus;
    protected int propStatus;
    protected int nodeKind;
    protected boolean treeConflicted;
    protected boolean fileExternal;
    protected SVNConflictDescriptor conflictDescriptor;

    protected ResourceStatus() {
    }

    public ResourceStatus(ISVNStatus status, String url) {
        Object aValue = null;
        aValue = status.getUrlString();
        this.url = aValue == null ? (url == null ? null : url) : aValue;
        aValue = status.getLastChangedRevision();
        this.lastChangedRevision = aValue == null ? -1L : ((SVNRevision.Number)aValue).getNumber();
        aValue = status.getLastChangedDate();
        this.lastChangedDate = aValue == null ? -1L : ((Date)aValue).getTime();
        this.lastCommitAuthor = status.getLastCommitAuthor();
        this.textStatus = status.getTextStatus().toInt();
        this.propStatus = status.getPropStatus().toInt();
        this.treeConflicted = status.hasTreeConflict();
        this.fileExternal = status.isFileExternal();
        this.conflictDescriptor = status.getConflictDescriptor();
        this.nodeKind = status.getNodeKind().toInt();
        this.file = status.getFile();
    }

    public String toString() {
        return String.valueOf(this.file != null ? this.file.getAbsolutePath() : "") + " (" + this.lastChangedRevision + ") " + this.getTextStatus().toString();
    }

    public File getFile() {
        return this.file;
    }

    public IPath getIPath() {
        return new Path(this.getPath());
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public SVNStatusKind getTextStatus() {
        SVNStatusKind statusKind = SVNStatusKind.fromInt((int)this.textStatus);
        statusKind.setTreeConflicted(this.treeConflicted);
        return statusKind;
    }

    public SVNStatusKind getPropStatus() {
        return SVNStatusKind.fromInt((int)this.propStatus);
    }

    public boolean hasTreeConflict() {
        return this.treeConflicted;
    }

    public boolean isFileExternal() {
        return this.fileExternal;
    }

    public SVNConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }

    public SVNStatusKind getStatusKind() {
        if (!(SVNStatusKind.NORMAL.equals((Object)this.getTextStatus()) || SVNStatusKind.EXTERNAL.equals((Object)this.getTextStatus()) || SVNStatusKind.NONE.equals((Object)this.getTextStatus()))) {
            return this.getTextStatus();
        }
        if (SVNStatusKind.MODIFIED.equals((Object)this.getPropStatus()) || SVNStatusKind.CONFLICTED.equals((Object)this.getPropStatus())) {
            return this.getPropStatus();
        }
        return this.getTextStatus();
    }

    public ISVNRepositoryLocation getRepository() {
        if (this.getUrlString() != null) {
            try {
                return SVNProviderPlugin.getPlugin().getRepository(this.getUrlString());
            }
            catch (SVNException e) {
                SVNProviderPlugin.log(e);
                return null;
            }
        }
        if (this.file != null) {
            return SVNWorkspaceRoot.getRepositoryFor((IPath)new Path(this.file.getAbsolutePath()));
        }
        return null;
    }

    public SVNNodeKind getNodeKind() {
        return SVNNodeKind.fromInt((int)this.nodeKind);
    }

    public SVNUrl getUrl() {
        if (this.url == null) {
            return null;
        }
        try {
            return new SVNUrl(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getUrlString() {
        return this.url;
    }

    public SVNRevision.Number getLastChangedRevision() {
        if (this.lastChangedRevision == -1L) {
            return null;
        }
        return new SVNRevision.Number(this.lastChangedRevision);
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate == -1L) {
            return null;
        }
        return new Date(this.lastChangedDate);
    }

    public String getLastCommitAuthor() {
        return this.lastCommitAuthor;
    }

    protected int initFromBytes(StatusFromBytesStream dis) throws SVNException {
        int version;
        try {
            version = dis.readInt();
            if (version != 1 && version != 2 && version != 3 && version != 4) {
                throw new SVNException("Invalid format");
            }
            if (version == 2) {
                this.readFromVersion2Stream(dis);
            } else {
                this.readFromVersion3Stream(dis);
            }
            if (version == 4) {
                this.readFromVersion4Stream(dis);
            }
        }
        catch (IOException e) {
            throw new SVNException("cannot create RemoteResourceStatus from bytes", e);
        }
        return version;
    }

    private void readFromVersion4Stream(StatusFromBytesStream dis) throws IOException {
        this.fileExternal = dis.readBoolean();
        this.treeConflicted = dis.readBoolean();
        if (this.treeConflicted) {
            int action = dis.readInt();
            int reason = dis.readInt();
            int operation = dis.readInt();
            String leftReposURL = dis.readString();
            long leftPegRevision = dis.readLong();
            String leftPathInRepos = dis.readString();
            int leftNodeKind = dis.readInt();
            SVNConflictVersion srcLeftVersion = new SVNConflictVersion(leftReposURL, leftPegRevision, leftPathInRepos, leftNodeKind);
            String rightReposURL = dis.readString();
            long rightPegRevision = dis.readLong();
            String rightPathInRepos = dis.readString();
            int rightNodeKind = dis.readInt();
            SVNConflictVersion srcRightVersion = new SVNConflictVersion(rightReposURL, rightPegRevision, rightPathInRepos, rightNodeKind);
            this.conflictDescriptor = new SVNConflictDescriptor(this.url, action, reason, operation, srcLeftVersion, srcRightVersion);
        } else {
            this.conflictDescriptor = null;
        }
    }

    private void readFromVersion3Stream(StatusFromBytesStream dis) throws IOException {
        this.url = dis.readString();
        this.lastChangedRevision = dis.readLong();
        this.lastChangedDate = dis.readLong();
        this.lastCommitAuthor = dis.readString();
        this.textStatus = dis.readInt();
        this.propStatus = dis.readInt();
        this.nodeKind = dis.readInt();
    }

    private void readFromVersion2Stream(StatusFromBytesStream dis) throws IOException {
        String urlString = dis.readUTF();
        this.url = urlString.equals("") ? null : urlString;
        this.lastChangedRevision = dis.readLong();
        this.lastChangedDate = dis.readLong();
        String lastCommitAuthorString = dis.readUTF();
        this.lastCommitAuthor = this.url == null || lastCommitAuthorString.equals("") ? null : lastCommitAuthorString;
        this.textStatus = dis.readInt();
        this.propStatus = dis.readInt();
        this.setRevisionNumber(dis.readLong());
        this.nodeKind = dis.readInt();
    }

    public byte[] getBytes() {
        StatusToBytesStream out = new StatusToBytesStream();
        this.getBytesInto(out);
        return out.toByteArray();
    }

    protected void getBytesInto(StatusToBytesStream dos) {
        try {
            dos.writeInt(4);
            dos.writeString(this.url);
            dos.writeLong(this.lastChangedRevision);
            dos.writeLong(this.lastChangedDate);
            dos.writeString(this.lastCommitAuthor);
            dos.writeInt(this.textStatus);
            dos.writeInt(this.propStatus);
            dos.writeInt(this.nodeKind);
            dos.writeBoolean(this.fileExternal);
            dos.writeBoolean(this.treeConflicted);
            if (this.treeConflicted && this.conflictDescriptor != null) {
                dos.writeInt(this.conflictDescriptor.getAction());
                dos.writeInt(this.conflictDescriptor.getReason());
                dos.writeInt(this.conflictDescriptor.getOperation());
                dos.writeString(this.conflictDescriptor.getSrcLeftVersion().getReposURL());
                dos.writeLong(this.conflictDescriptor.getSrcLeftVersion().getPegRevision());
                dos.writeString(this.conflictDescriptor.getSrcLeftVersion().getPathInRepos());
                dos.writeInt(this.conflictDescriptor.getSrcLeftVersion().getNodeKind());
                dos.writeString(this.conflictDescriptor.getSrcRightVersion().getReposURL());
                dos.writeLong(this.conflictDescriptor.getSrcRightVersion().getPegRevision());
                dos.writeString(this.conflictDescriptor.getSrcRightVersion().getPathInRepos());
                dos.writeInt(this.conflictDescriptor.getSrcRightVersion().getNodeKind());
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected void setRevisionNumber(long revision) {
    }

    protected static final class StatusToBytesStream
    extends ByteArrayOutputStream {
        protected StatusToBytesStream() {
            super(256);
        }

        public final void write(int b) {
            this.buf[this.count] = (byte)b;
            ++this.count;
        }

        private void ensureCapacity(int length) {
            int newcount = this.count + length;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length + 100, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
        }

        public final byte[] toByteArray() {
            return this.buf;
        }

        public final void writeLong(long v) throws IOException {
            this.ensureCapacity(8);
            this.write((byte)(v >>> 56));
            this.write((byte)(v >>> 48));
            this.write((byte)(v >>> 40));
            this.write((byte)(v >>> 32));
            this.write((byte)(v >>> 24));
            this.write((byte)(v >>> 16));
            this.write((byte)(v >>> 8));
            this.write((byte)(v >>> 0));
        }

        public final void writeInt(int v) throws IOException {
            this.ensureCapacity(4);
            this.write(v >>> 24 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        public final void writeBoolean(boolean v) throws IOException {
            this.ensureCapacity(1);
            this.write(v ? 1 : 0);
        }

        public final void writeString(String v) throws IOException {
            int length = v != null ? v.length() : 0;
            this.writeInt(length);
            this.ensureCapacity(length * 2);
            int i = 0;
            while (i < length) {
                char c = v.charAt(i);
                this.write(c >>> 8 & 0xFF);
                this.write(c >>> 0 & 0xFF);
                ++i;
            }
        }
    }

    protected static final class StatusFromBytesStream
    extends ByteArrayInputStream {
        private DataInputStream dis = new DataInputStream(this);

        protected StatusFromBytesStream(byte[] buf) {
            super(buf);
        }

        public final int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        public final int read(byte[] b, int off, int len) {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + len > this.count) {
                len = this.count - this.pos;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public final long readLong() throws IOException {
            return this.dis.readLong();
        }

        public final int readInt() throws IOException {
            return this.dis.readInt();
        }

        public final boolean readBoolean() throws IOException {
            return this.dis.readBoolean();
        }

        public final String readString() throws IOException {
            int length = this.dis.readInt();
            if (length == 0) {
                return null;
            }
            char[] chars = new char[length];
            int i = 0;
            while (i < length) {
                chars[i] = this.dis.readChar();
                ++i;
            }
            return new String(chars);
        }

        public final String readUTF() throws IOException {
            return this.dis.readUTF();
        }
    }
}

