/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;

public class FileModificationManager
implements IResourceChangeListener,
ISaveParticipant {
    protected int INTERESTING_CHANGES = 323840;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResource[] resources;
            final ArrayList modifiedResources = new ArrayList();
            final ArrayList modifiedInfiniteDepthResources = new ArrayList();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1) {
                        if (delta.getKind() == 4 && resource.exists()) {
                            if ((delta.getFlags() & FileModificationManager.this.INTERESTING_CHANGES) != 0) {
                                modifiedResources.add(resource);
                                return true;
                            }
                        } else {
                            if (delta.getKind() == 1) {
                                modifiedResources.add(resource);
                                return true;
                            }
                            if (delta.getKind() == 2) {
                                modifiedResources.add(resource);
                                return true;
                            }
                        }
                    } else {
                        if (resource.getType() == 2) {
                            if (delta.getKind() == 1) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                            if (delta.getKind() == 2) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                            return true;
                        }
                        if (resource.getType() == 4) {
                            IProject project = (IProject)resource;
                            if ((delta.getKind() & 2) != 0) {
                                SVNWorkspaceRoot.unsetManagedBySubclipse(project);
                                return false;
                            }
                            if (!project.isAccessible()) {
                                return false;
                            }
                            if ((delta.getFlags() & 0x4000) != 0) {
                                return false;
                            }
                            if (!SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                                return false;
                            }
                            if (delta.getKind() == 1) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                            if (delta.getKind() == 2) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                        }
                    }
                    return true;
                }
            });
            if (!modifiedResources.isEmpty()) {
                resources = modifiedResources.toArray(new IResource[modifiedResources.size()]);
                this.refreshStatus(resources);
                SVNProviderPlugin.broadcastModificationStateChanges(resources);
            }
            if (!modifiedInfiniteDepthResources.isEmpty()) {
                resources = modifiedInfiniteDepthResources.toArray(new IResource[modifiedInfiniteDepthResources.size()]);
                this.refreshStatusInfitite(resources);
                SVNProviderPlugin.broadcastModificationStateChanges(resources);
            }
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
    }

    private void refreshStatusInfitite(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            try {
                SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IContainer)resources[i], true);
            }
            catch (SVNException e) {
                SVNProviderPlugin.log(4, e.getMessage(), (Throwable)((Object)e));
            }
            ++i;
        }
    }

    private void refreshStatus(IResource[] resources) {
        HashSet<Object> foldersToRefresh = new HashSet<Object>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 1) {
                foldersToRefresh.add(resources[i].getParent());
            } else {
                foldersToRefresh.add(resources[i]);
            }
            ++i;
        }
        Iterator it = foldersToRefresh.iterator();
        while (it.hasNext()) {
            IResource folder = (IResource)it.next();
            try {
                SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IContainer)folder, false);
            }
            catch (SVNException e) {
                SVNProviderPlugin.log(4, e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    public void registerSaveParticipant() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ISavedState ss = ws.addSaveParticipant((Plugin)SVNProviderPlugin.getPlugin(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
        ws.removeSaveParticipant((Plugin)SVNProviderPlugin.getPlugin());
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) {
    }
}

