/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.ANTXRHashString;
import com.javadude.antxr.ANTXRStringBuffer;
import com.javadude.antxr.CharStreamException;
import com.javadude.antxr.InputBuffer;
import com.javadude.antxr.LexerSharedInputState;
import com.javadude.antxr.MismatchedCharException;
import com.javadude.antxr.RecognitionException;
import com.javadude.antxr.Token;
import com.javadude.antxr.TokenStream;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.Utils;
import com.javadude.antxr.collections.impl.BitSet;
import java.util.Hashtable;

public abstract class CharScanner
implements TokenStream {
    static final char NO_CHAR = '\u0000';
    public static final char EOF_CHAR = '\uffff';
    protected ANTXRStringBuffer text = new ANTXRStringBuffer();
    protected boolean saveConsumedInput = true;
    protected Class tokenObjectClass;
    protected boolean caseSensitive = true;
    protected boolean caseSensitiveLiterals = true;
    protected Hashtable literals;
    protected int tabsize = 8;
    protected Token _returnToken = null;
    protected ANTXRHashString hashString = new ANTXRHashString(this);
    protected LexerSharedInputState inputState;
    protected boolean commitToPath = false;
    protected int traceDepth = 0;

    public CharScanner() {
        this.setTokenObjectClass("com.javadude.antxr.CommonToken");
    }

    public CharScanner(InputBuffer cb) {
        this();
        this.inputState = new LexerSharedInputState(cb);
    }

    public CharScanner(LexerSharedInputState sharedState) {
        this();
        this.inputState = sharedState;
    }

    public void append(char c) {
        if (this.saveConsumedInput) {
            this.text.append(c);
        }
    }

    public void append(String s) {
        if (this.saveConsumedInput) {
            this.text.append(s);
        }
    }

    public void commit() {
        this.inputState.input.commit();
    }

    public void consume() throws CharStreamException {
        if (this.inputState.guessing == 0) {
            char c = this.LA(1);
            if (this.caseSensitive) {
                this.append(c);
            } else {
                this.append(this.inputState.input.LA(1));
            }
            if (c == '\t') {
                this.tab();
            } else {
                ++this.inputState.column;
            }
        }
        this.inputState.input.consume();
    }

    public void consumeUntil(int c) throws CharStreamException {
        while (this.LA(1) != '\uffff' && this.LA(1) != c) {
            this.consume();
        }
    }

    public void consumeUntil(BitSet set) throws CharStreamException {
        while (this.LA(1) != '\uffff' && !set.member(this.LA(1))) {
            this.consume();
        }
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public final boolean getCaseSensitiveLiterals() {
        return this.caseSensitiveLiterals;
    }

    public int getColumn() {
        return this.inputState.column;
    }

    public void setColumn(int c) {
        this.inputState.column = c;
    }

    public boolean getCommitToPath() {
        return this.commitToPath;
    }

    public String getFilename() {
        return this.inputState.filename;
    }

    public InputBuffer getInputBuffer() {
        return this.inputState.input;
    }

    public LexerSharedInputState getInputState() {
        return this.inputState;
    }

    public void setInputState(LexerSharedInputState state) {
        this.inputState = state;
    }

    public int getLine() {
        return this.inputState.line;
    }

    public String getText() {
        return this.text.toString();
    }

    public Token getTokenObject() {
        return this._returnToken;
    }

    public char LA(int i) throws CharStreamException {
        if (this.caseSensitive) {
            return this.inputState.input.LA(i);
        }
        return this.toLower(this.inputState.input.LA(i));
    }

    protected Token makeToken(int t) {
        try {
            Token tok = (Token)this.tokenObjectClass.newInstance();
            tok.setType(t);
            tok.setColumn(this.inputState.tokenStartColumn);
            tok.setLine(this.inputState.tokenStartLine);
            return tok;
        }
        catch (InstantiationException instantiationException) {
            this.panic("can't instantiate token: " + this.tokenObjectClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.panic("Token class is not accessible" + this.tokenObjectClass);
        }
        return Token.badToken;
    }

    public int mark() {
        return this.inputState.input.mark();
    }

    public void match(char c) throws MismatchedCharException, CharStreamException {
        if (this.LA(1) != c) {
            throw new MismatchedCharException(this.LA(1), c, false, this);
        }
        this.consume();
    }

    public void match(BitSet b) throws MismatchedCharException, CharStreamException {
        if (!b.member(this.LA(1))) {
            throw new MismatchedCharException(this.LA(1), b, false, this);
        }
        this.consume();
    }

    public void match(String s) throws MismatchedCharException, CharStreamException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            if (this.LA(1) != s.charAt(i)) {
                throw new MismatchedCharException(this.LA(1), s.charAt(i), false, this);
            }
            this.consume();
            ++i;
        }
    }

    public void matchNot(char c) throws MismatchedCharException, CharStreamException {
        if (this.LA(1) == c) {
            throw new MismatchedCharException(this.LA(1), c, true, this);
        }
        this.consume();
    }

    public void matchRange(char c1, char c2) throws MismatchedCharException, CharStreamException {
        if (this.LA(1) < c1 || this.LA(1) > c2) {
            throw new MismatchedCharException(this.LA(1), c1, c2, false, this);
        }
        this.consume();
    }

    public void newline() {
        ++this.inputState.line;
        this.inputState.column = 1;
    }

    public void tab() {
        int c = this.getColumn();
        int nc = ((c - 1) / this.tabsize + 1) * this.tabsize + 1;
        this.setColumn(nc);
    }

    public void setTabSize(int size) {
        this.tabsize = size;
    }

    public int getTabSize() {
        return this.tabsize;
    }

    public void panic() {
        System.err.println("CharScanner: panic");
        Utils.error("");
    }

    public void panic(String s) {
        System.err.println("CharScanner; panic: " + s);
        Utils.error(s);
    }

    public void reportError(RecognitionException ex) {
        System.err.println(ex);
    }

    public void reportError(String s) {
        if (this.getFilename() == null) {
            System.err.println("error: " + s);
        } else {
            System.err.println(String.valueOf(this.getFilename()) + ": error: " + s);
        }
    }

    public void reportWarning(String s) {
        if (this.getFilename() == null) {
            System.err.println("warning: " + s);
        } else {
            System.err.println(String.valueOf(this.getFilename()) + ": warning: " + s);
        }
    }

    public void resetText() {
        this.text.setLength(0);
        this.inputState.tokenStartColumn = this.inputState.column;
        this.inputState.tokenStartLine = this.inputState.line;
    }

    public void rewind(int pos) {
        this.inputState.input.rewind(pos);
    }

    public void setCaseSensitive(boolean t) {
        this.caseSensitive = t;
    }

    public void setCommitToPath(boolean commit) {
        this.commitToPath = commit;
    }

    public void setFilename(String f) {
        this.inputState.filename = f;
    }

    public void setLine(int line) {
        this.inputState.line = line;
    }

    public void setText(String s) {
        this.resetText();
        this.text.append(s);
    }

    public void setTokenObjectClass(String cl) {
        try {
            this.tokenObjectClass = Utils.loadClass(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.panic("ClassNotFoundException: " + cl);
        }
    }

    public int testLiteralsTable(int ttype) {
        this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
        Integer literalsIndex = (Integer)this.literals.get(this.hashString);
        if (literalsIndex != null) {
            ttype = literalsIndex;
        }
        return ttype;
    }

    public int testLiteralsTable(String text, int ttype) {
        ANTXRHashString s = new ANTXRHashString(text, this);
        Integer literalsIndex = (Integer)this.literals.get(s);
        if (literalsIndex != null) {
            ttype = literalsIndex;
        }
        return ttype;
    }

    public char toLower(char c) {
        return Character.toLowerCase(c);
    }

    public void traceIndent() {
        int i = 0;
        while (i < this.traceDepth) {
            System.out.print(" ");
            ++i;
        }
    }

    public void traceIn(String rname) throws CharStreamException {
        ++this.traceDepth;
        this.traceIndent();
        System.out.println("> lexer " + rname + "; c==" + this.LA(1));
    }

    public void traceOut(String rname) throws CharStreamException {
        this.traceIndent();
        System.out.println("< lexer " + rname + "; c==" + this.LA(1));
        --this.traceDepth;
    }

    public void uponEOF() throws TokenStreamException, CharStreamException {
    }
}

