/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.ActionElement;
import com.javadude.antxr.ActionTransInfo;
import com.javadude.antxr.AlternativeBlock;
import com.javadude.antxr.BlockEndElement;
import com.javadude.antxr.CharFormatter;
import com.javadude.antxr.CharLiteralElement;
import com.javadude.antxr.CharRangeElement;
import com.javadude.antxr.DefineGrammarSymbols;
import com.javadude.antxr.Grammar;
import com.javadude.antxr.GrammarAtom;
import com.javadude.antxr.GrammarSymbol;
import com.javadude.antxr.LLkGrammarAnalyzer;
import com.javadude.antxr.LexerGrammar;
import com.javadude.antxr.Lookahead;
import com.javadude.antxr.OneOrMoreBlock;
import com.javadude.antxr.ParserGrammar;
import com.javadude.antxr.RuleBlock;
import com.javadude.antxr.RuleRefElement;
import com.javadude.antxr.RuleSymbol;
import com.javadude.antxr.StringLiteralElement;
import com.javadude.antxr.StringLiteralSymbol;
import com.javadude.antxr.Token;
import com.javadude.antxr.TokenManager;
import com.javadude.antxr.TokenRangeElement;
import com.javadude.antxr.TokenRefElement;
import com.javadude.antxr.TokenSymbol;
import com.javadude.antxr.Tool;
import com.javadude.antxr.TreeElement;
import com.javadude.antxr.TreeWalkerGrammar;
import com.javadude.antxr.WildcardElement;
import com.javadude.antxr.ZeroOrMoreBlock;
import com.javadude.antxr.collections.impl.BitSet;
import com.javadude.antxr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class CodeGenerator {
    protected Tool antxrTool;
    protected int tabs = 0;
    protected transient PrintWriter currentOutput;
    protected Grammar grammar = null;
    protected Vector bitsetsUsed;
    protected DefineGrammarSymbols behavior;
    protected LLkGrammarAnalyzer analyzer;
    protected CharFormatter charFormatter;
    protected boolean DEBUG_CODE_GENERATOR = false;
    protected static final int DEFAULT_MAKE_SWITCH_THRESHOLD = 2;
    protected static final int DEFAULT_BITSET_TEST_THRESHOLD = 4;
    protected static final int BITSET_OPTIMIZE_INIT_THRESHOLD = 8;
    protected int makeSwitchThreshold = 2;
    protected int bitsetTestThreshold = 4;
    public static String TokenTypesFileSuffix = "TokenTypes";
    public static String TokenTypesFileExt = ".txt";

    protected void _print(String s) {
        if (s != null) {
            this.currentOutput.print(s);
        }
    }

    protected void _printAction(String s) {
        if (s == null) {
            return;
        }
        int start = 0;
        while (start < s.length() && Character.isSpaceChar(s.charAt(start))) {
            ++start;
        }
        int end = s.length() - 1;
        while (end > start && Character.isSpaceChar(s.charAt(end))) {
            --end;
        }
        char c = '\u0000';
        int i = start;
        while (i <= end) {
            c = s.charAt(i);
            ++i;
            boolean newline = false;
            switch (c) {
                case '\n': {
                    newline = true;
                    break;
                }
                case '\r': {
                    if (i <= end && s.charAt(i) == '\n') {
                        ++i;
                    }
                    newline = true;
                    break;
                }
                default: {
                    this.currentOutput.print(c);
                }
            }
            if (!newline) continue;
            this.currentOutput.println();
            this.printTabs();
            while (i <= end && Character.isSpaceChar(s.charAt(i))) {
                ++i;
            }
            newline = false;
        }
        this.currentOutput.println();
    }

    protected void _println(String s) {
        if (s != null) {
            this.currentOutput.println(s);
        }
    }

    public static boolean elementsAreRange(int[] elems) {
        if (elems.length == 0) {
            return false;
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        if (elems.length <= 2) {
            return false;
        }
        if (end - begin + 1 > elems.length) {
            return false;
        }
        int v = begin + 1;
        int i = 1;
        while (i < elems.length - 1) {
            if (v != elems[i]) {
                return false;
            }
            ++v;
            ++i;
        }
        return true;
    }

    protected String extractIdOfAction(Token t) {
        return this.extractIdOfAction(t.getText(), t.getLine(), t.getColumn());
    }

    protected String extractIdOfAction(String s, int line, int column) {
        s = this.removeAssignmentFromDeclaration(s);
        int i = s.length() - 2;
        while (i >= 0) {
            if (!Character.isLetterOrDigit(s.charAt(i)) && s.charAt(i) != '_') {
                return s.substring(i + 1);
            }
            --i;
        }
        this.antxrTool.warning("Ill-formed action", this.grammar.getFilename(), line, column);
        return "";
    }

    protected String extractTypeOfAction(Token t) {
        return this.extractTypeOfAction(t.getText(), t.getLine(), t.getColumn());
    }

    protected String extractTypeOfAction(String s, int line, int column) {
        s = this.removeAssignmentFromDeclaration(s);
        int i = s.length() - 2;
        while (i >= 0) {
            if (!Character.isLetterOrDigit(s.charAt(i)) && s.charAt(i) != '_') {
                return s.substring(0, i + 1);
            }
            --i;
        }
        this.antxrTool.warning("Ill-formed action", this.grammar.getFilename(), line, column);
        return "";
    }

    public abstract void gen();

    public abstract void gen(ActionElement var1);

    public abstract void gen(AlternativeBlock var1);

    public abstract void gen(BlockEndElement var1);

    public abstract void gen(CharLiteralElement var1);

    public abstract void gen(CharRangeElement var1);

    public abstract void gen(LexerGrammar var1) throws IOException;

    public abstract void gen(OneOrMoreBlock var1);

    public abstract void gen(ParserGrammar var1) throws IOException;

    public abstract void gen(RuleRefElement var1);

    public abstract void gen(StringLiteralElement var1);

    public abstract void gen(TokenRangeElement var1);

    public abstract void gen(TokenRefElement var1);

    public abstract void gen(TreeElement var1);

    public abstract void gen(TreeWalkerGrammar var1) throws IOException;

    public abstract void gen(WildcardElement var1);

    public abstract void gen(ZeroOrMoreBlock var1);

    protected void genTokenInterchange(TokenManager tm) throws IOException {
        String fName = String.valueOf(tm.getName()) + TokenTypesFileSuffix + TokenTypesFileExt;
        this.currentOutput = this.antxrTool.openOutputFile(fName);
        this.println("// $ANTXR " + Tool.version + ": " + this.antxrTool.fileMinusPath(this.antxrTool.grammarFile) + " -> " + fName + "$");
        this.tabs = 0;
        this.println(String.valueOf(tm.getName()) + "    // output token vocab name");
        Vector v = tm.getVocabulary();
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("gen persistence file entry for: " + s);
            }
            if (s != null && !s.startsWith("<")) {
                if (s.startsWith("\"")) {
                    StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                    if (sl != null && sl.label != null) {
                        this.print(String.valueOf(sl.label) + "=");
                    }
                    this.println(String.valueOf(s) + "=" + i);
                } else {
                    this.print(s);
                    TokenSymbol ts = tm.getTokenSymbol(s);
                    if (ts == null) {
                        this.antxrTool.warning("undefined token symbol: " + s);
                    } else if (ts.getParaphrase() != null) {
                        this.print("(" + ts.getParaphrase() + ")");
                    }
                    this.println("=" + i);
                }
            }
            ++i;
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String processStringForASTConstructor(String str) {
        return str;
    }

    public abstract String getASTCreateString(Vector var1);

    public abstract String getASTCreateString(GrammarAtom var1, String var2);

    protected String getBitsetName(int index) {
        return "_tokenSet_" + index;
    }

    public static String encodeLexerRuleName(String id) {
        return "m" + id;
    }

    public static String decodeLexerRuleName(String id) {
        if (id == null) {
            return null;
        }
        return id.substring(1, id.length());
    }

    public abstract String mapTreeId(String var1, ActionTransInfo var2);

    protected int markBitsetForGen(BitSet p) {
        int i = 0;
        while (i < this.bitsetsUsed.size()) {
            BitSet set = (BitSet)this.bitsetsUsed.elementAt(i);
            if (p.equals(set)) {
                return i;
            }
            ++i;
        }
        this.bitsetsUsed.appendElement(p.clone());
        return this.bitsetsUsed.size() - 1;
    }

    protected void print(String s) {
        if (s != null) {
            this.printTabs();
            this.currentOutput.print(s);
        }
    }

    protected void printAction(String s) {
        if (s != null) {
            this.printTabs();
            this._printAction(s);
        }
    }

    protected void println(String s) {
        if (s != null) {
            this.printTabs();
            this.currentOutput.println(s);
        }
    }

    protected void printTabs() {
        int i = 1;
        while (i <= this.tabs) {
            this.currentOutput.print("\t");
            ++i;
        }
    }

    protected abstract String processActionForSpecialSymbols(String var1, int var2, RuleBlock var3, ActionTransInfo var4);

    public String getFOLLOWBitSet(String ruleName, int k) {
        GrammarSymbol rs = this.grammar.getSymbol(ruleName);
        if (!(rs instanceof RuleSymbol)) {
            return null;
        }
        RuleBlock blk = ((RuleSymbol)rs).getBlock();
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(k, blk.endNode);
        String followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
        return followSetName;
    }

    public String getFIRSTBitSet(String ruleName, int k) {
        GrammarSymbol rs = this.grammar.getSymbol(ruleName);
        if (!(rs instanceof RuleSymbol)) {
            return null;
        }
        RuleBlock blk = ((RuleSymbol)rs).getBlock();
        Lookahead first = this.grammar.theLLkAnalyzer.look(k, blk);
        String firstSetName = this.getBitsetName(this.markBitsetForGen(first.fset));
        return firstSetName;
    }

    protected String removeAssignmentFromDeclaration(String d) {
        if (d.indexOf(61) >= 0) {
            d = d.substring(0, d.indexOf(61)).trim();
        }
        return d;
    }

    private void reset() {
        this.tabs = 0;
        this.bitsetsUsed = new Vector();
        this.currentOutput = null;
        this.grammar = null;
        this.DEBUG_CODE_GENERATOR = false;
        this.makeSwitchThreshold = 2;
        this.bitsetTestThreshold = 4;
    }

    public static String reverseLexerRuleName(String id) {
        return id.substring(1, id.length());
    }

    public void setAnalyzer(LLkGrammarAnalyzer analyzer_) {
        this.analyzer = analyzer_;
    }

    public void setBehavior(DefineGrammarSymbols behavior_) {
        this.behavior = behavior_;
    }

    protected void setGrammar(Grammar g) {
        Token tok;
        this.reset();
        this.grammar = g;
        if (this.grammar.hasOption("codeGenMakeSwitchThreshold")) {
            try {
                this.makeSwitchThreshold = this.grammar.getIntegerOption("codeGenMakeSwitchThreshold");
            }
            catch (NumberFormatException numberFormatException) {
                tok = this.grammar.getOption("codeGenMakeSwitchThreshold");
                this.antxrTool.error("option 'codeGenMakeSwitchThreshold' must be an integer", this.grammar.getClassName(), tok.getLine(), tok.getColumn());
            }
        }
        if (this.grammar.hasOption("codeGenBitsetTestThreshold")) {
            try {
                this.bitsetTestThreshold = this.grammar.getIntegerOption("codeGenBitsetTestThreshold");
            }
            catch (NumberFormatException numberFormatException) {
                tok = this.grammar.getOption("codeGenBitsetTestThreshold");
                this.antxrTool.error("option 'codeGenBitsetTestThreshold' must be an integer", this.grammar.getClassName(), tok.getLine(), tok.getColumn());
            }
        }
        if (this.grammar.hasOption("codeGenDebug")) {
            Token t = this.grammar.getOption("codeGenDebug");
            if (t.getText().equals("true")) {
                this.DEBUG_CODE_GENERATOR = true;
            } else if (t.getText().equals("false")) {
                this.DEBUG_CODE_GENERATOR = false;
            } else {
                this.antxrTool.error("option 'codeGenDebug' must be true or false", this.grammar.getClassName(), t.getLine(), t.getColumn());
            }
        }
    }

    public void setTool(Tool tool) {
        this.antxrTool = tool;
    }
}

