/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.Grammar;
import com.javadude.antxr.JavaCodeGeneratorPrintWriterManager;
import com.javadude.antxr.PrintWriterWithSMAP;
import com.javadude.antxr.Tool;
import java.io.IOException;
import java.io.PrintWriter;

public class DefaultJavaCodeGeneratorPrintWriterManager
implements JavaCodeGeneratorPrintWriterManager {
    private Grammar grammar;
    private PrintWriterWithSMAP smapOutput;
    private PrintWriter currentOutput;
    private Tool tool;

    public PrintWriter setupOutput(Tool tool, Grammar grammar, boolean generateSmap) throws IOException {
        return this.setupOutput(tool, grammar, null, generateSmap);
    }

    public PrintWriter setupOutput(Tool tool, String fileName, boolean generateSmap) throws IOException {
        return this.setupOutput(tool, null, fileName, generateSmap);
    }

    public PrintWriter setupOutput(Tool tool, Grammar grammar, String fileName, boolean generateSmap) throws IOException {
        this.tool = tool;
        this.grammar = grammar;
        if (fileName == null) {
            fileName = grammar.getClassName();
        }
        if (generateSmap) {
            this.smapOutput = new PrintWriterWithSMAP(tool.openOutputFile(String.valueOf(fileName) + ".java"));
            this.currentOutput = this.smapOutput;
        } else {
            this.currentOutput = tool.openOutputFile(String.valueOf(fileName) + ".java");
        }
        return this.currentOutput;
    }

    public void startMapping(int sourceLine) {
        if (this.smapOutput != null) {
            this.smapOutput.startMapping(sourceLine);
        }
    }

    public void startSingleSourceLineMapping(int sourceLine) {
        if (this.smapOutput != null) {
            this.smapOutput.startSingleSourceLineMapping(sourceLine);
        }
    }

    public void endMapping() {
        if (this.smapOutput != null) {
            this.smapOutput.endMapping();
        }
    }

    public void finishOutput() throws IOException {
        this.currentOutput.close();
        if (this.grammar != null && this.smapOutput != null) {
            PrintWriter smapWriter = this.tool.openOutputFile(String.valueOf(this.grammar.getClassName()) + ".smap");
            String grammarFile = this.grammar.getFilename();
            int lastSlash = (grammarFile = grammarFile.replace('\\', '/')).lastIndexOf(47);
            if (lastSlash != -1) {
                grammarFile = grammarFile.substring(lastSlash + 1);
            }
            this.smapOutput.dump(smapWriter, this.grammar.getClassName(), grammarFile);
        }
        this.currentOutput = null;
    }
}

