/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.Alternative;
import com.javadude.antxr.AlternativeBlock;
import com.javadude.antxr.BlockWithImpliedExitPath;
import com.javadude.antxr.CharFormatter;
import com.javadude.antxr.CodeGenerator;
import com.javadude.antxr.Grammar;
import com.javadude.antxr.JavaCharFormatter;
import com.javadude.antxr.Lookahead;
import com.javadude.antxr.RuleBlock;
import com.javadude.antxr.RuleRefElement;
import com.javadude.antxr.Tool;
import com.javadude.antxr.ToolErrorHandler;

class DefaultToolErrorHandler
implements ToolErrorHandler {
    private final Tool antxrTool;
    CharFormatter javaCharFormatter = new JavaCharFormatter();

    DefaultToolErrorHandler(Tool tool) {
        this.antxrTool = tool;
    }

    private void dumpSets(String[] output, int outputStartIndex, Grammar grammar, boolean lexicalAnalysis, int depth, Lookahead[] sets) {
        StringBuffer line = new StringBuffer(100);
        int i = 1;
        while (i <= depth) {
            line.append("k==").append(i).append(':');
            if (lexicalAnalysis) {
                String bits = sets[i].fset.toStringWithRanges(",", this.javaCharFormatter);
                if (sets[i].containsEpsilon()) {
                    line.append("<end-of-token>");
                    if (bits.length() > 0) {
                        line.append(',');
                    }
                }
                line.append(bits);
            } else {
                line.append(sets[i].fset.toString(",", grammar.tokenManager.getVocabulary()));
            }
            output[outputStartIndex++] = line.toString();
            line.setLength(0);
            ++i;
        }
    }

    public void warnAltAmbiguity(Grammar grammar, AlternativeBlock blk, boolean lexicalAnalysis, int depth, Lookahead[] sets, int altIdx1, int altIdx2) {
        StringBuffer line = new StringBuffer(100);
        if (blk instanceof RuleBlock && ((RuleBlock)blk).isLexerAutoGenRule()) {
            Alternative ai = blk.getAlternativeAt(altIdx1);
            Alternative aj = blk.getAlternativeAt(altIdx2);
            RuleRefElement rri = (RuleRefElement)ai.head;
            RuleRefElement rrj = (RuleRefElement)aj.head;
            String ri = CodeGenerator.reverseLexerRuleName(rri.targetRule);
            String rj = CodeGenerator.reverseLexerRuleName(rrj.targetRule);
            line.append("lexical nondeterminism between rules ");
            line.append(ri).append(" and ").append(rj).append(" upon");
        } else {
            if (lexicalAnalysis) {
                line.append("lexical ");
            }
            line.append("nondeterminism between alts ");
            line.append(altIdx1 + 1).append(" and ");
            line.append(altIdx2 + 1).append(" of block upon");
        }
        String[] output = new String[depth + 1];
        output[0] = line.toString();
        this.dumpSets(output, 1, grammar, lexicalAnalysis, depth, sets);
        this.antxrTool.warning(output, grammar.getFilename(), blk.getLine(), blk.getColumn());
    }

    public void warnAltExitAmbiguity(Grammar grammar, BlockWithImpliedExitPath blk, boolean lexicalAnalysis, int depth, Lookahead[] sets, int altIdx) {
        String[] output = new String[depth + 2];
        output[0] = String.valueOf(lexicalAnalysis ? "lexical " : "") + "nondeterminism upon";
        this.dumpSets(output, 1, grammar, lexicalAnalysis, depth, sets);
        output[depth + 1] = "between alt " + (altIdx + 1) + " and exit branch of block";
        this.antxrTool.warning(output, grammar.getFilename(), blk.getLine(), blk.getColumn());
    }
}

