/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.ANTXRTokdefLexer;
import com.javadude.antxr.ANTXRTokdefParser;
import com.javadude.antxr.Grammar;
import com.javadude.antxr.RecognitionException;
import com.javadude.antxr.SimpleTokenManager;
import com.javadude.antxr.StringLiteralSymbol;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.TokenSymbol;
import com.javadude.antxr.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    private String filename;
    protected Grammar grammar;

    ImportVocabTokenManager(Grammar grammar, String filename_, String name_, Tool tool_) {
        super(name_, tool_);
        this.grammar = grammar;
        this.filename = filename_;
        File grammarFile = new File(this.filename);
        if (!grammarFile.exists() && !(grammarFile = new File(this.antxrTool.getOutputDirectory(), this.filename)).exists()) {
            this.antxrTool.fatalError("panic: Cannot find importVocab file '" + this.filename + "'");
        }
        this.setReadOnly(true);
        try {
            BufferedReader fileIn = new BufferedReader(new FileReader(grammarFile));
            ANTXRTokdefLexer tokdefLexer = new ANTXRTokdefLexer(fileIn);
            ANTXRTokdefParser tokdefParser = new ANTXRTokdefParser(tokdefLexer);
            tokdefParser.setTool(this.antxrTool);
            tokdefParser.setFilename(this.filename);
            tokdefParser.file(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.antxrTool.fatalError("panic: Cannot find importVocab file '" + this.filename + "'");
        }
        catch (RecognitionException ex) {
            this.antxrTool.fatalError("panic: Error parsing importVocab file '" + this.filename + "': " + ex.toString());
        }
        catch (TokenStreamException tokenStreamException) {
            this.antxrTool.fatalError("panic: Error reading importVocab file '" + this.filename + "'");
        }
    }

    public Object clone() {
        ImportVocabTokenManager tm = (ImportVocabTokenManager)super.clone();
        tm.filename = this.filename;
        tm.grammar = this.grammar;
        return tm;
    }

    public void define(TokenSymbol ts) {
        super.define(ts);
    }

    public void define(String s, int ttype) {
        TokenSymbol ts = null;
        ts = s.startsWith("\"") ? new StringLiteralSymbol(s) : new TokenSymbol(s);
        ts.setTokenType(ttype);
        super.define(ts);
        this.maxToken = ttype + 1 > this.maxToken ? ttype + 1 : this.maxToken;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int nextTokenType() {
        return super.nextTokenType();
    }
}

