/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.Grammar;
import com.javadude.antxr.Token;
import com.javadude.antxr.Tool;
import com.javadude.antxr.collections.impl.BitSet;
import java.io.IOException;

class LexerGrammar
extends Grammar {
    protected BitSet charVocabulary;
    protected boolean testLiterals = true;
    protected boolean caseSensitiveLiterals = true;
    protected boolean caseSensitive = true;
    protected boolean filterMode = false;
    protected String filterRule = null;

    LexerGrammar(String className_, Tool tool_, String superClass) {
        super(className_, tool_, superClass);
        BitSet cv = new BitSet();
        int i = 0;
        while (i <= 127) {
            cv.add(i);
            ++i;
        }
        this.setCharVocabulary(cv);
        this.defaultErrorHandler = false;
    }

    public void generate() throws IOException {
        this.generator.gen(this);
    }

    public String getSuperClass() {
        if (this.debuggingOutput) {
            return "debug.DebuggingCharScanner";
        }
        return "CharScanner";
    }

    public boolean getTestLiterals() {
        return this.testLiterals;
    }

    public void processArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-trace")) {
                this.traceRules = true;
                this.antxrTool.setArgOK(i);
            } else if (args[i].equals("-traceLexer")) {
                this.traceRules = true;
                this.antxrTool.setArgOK(i);
            } else if (args[i].equals("-debug")) {
                this.debuggingOutput = true;
                this.antxrTool.setArgOK(i);
            } else if (args[i].equals("-smap")) {
                this.generateSmap = true;
                this.antxrTool.setArgOK(i);
            }
            ++i;
        }
    }

    public void setCharVocabulary(BitSet b) {
        this.charVocabulary = b;
    }

    public boolean setOption(String key, Token value) {
        String s = value.getText();
        if (key.equals("buildAST")) {
            this.antxrTool.warning("buildAST option is not valid for lexer", this.getFilename(), value.getLine(), value.getColumn());
            return true;
        }
        if (key.equals("testLiterals")) {
            if (s.equals("true")) {
                this.testLiterals = true;
            } else if (s.equals("false")) {
                this.testLiterals = false;
            } else {
                this.antxrTool.warning("testLiterals option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("interactive")) {
            if (s.equals("true")) {
                this.interactive = true;
            } else if (s.equals("false")) {
                this.interactive = false;
            } else {
                this.antxrTool.error("interactive option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("caseSensitive")) {
            if (s.equals("true")) {
                this.caseSensitive = true;
            } else if (s.equals("false")) {
                this.caseSensitive = false;
            } else {
                this.antxrTool.warning("caseSensitive option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("caseSensitiveLiterals")) {
            if (s.equals("true")) {
                this.caseSensitiveLiterals = true;
            } else if (s.equals("false")) {
                this.caseSensitiveLiterals = false;
            } else {
                this.antxrTool.warning("caseSensitiveLiterals option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("filter")) {
            if (s.equals("true")) {
                this.filterMode = true;
            } else if (s.equals("false")) {
                this.filterMode = false;
            } else if (value.getType() == 25) {
                this.filterMode = true;
                this.filterRule = s;
            } else {
                this.antxrTool.warning("filter option must be true, false, or a lexer rule name", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("longestPossible")) {
            this.antxrTool.warning("longestPossible option has been deprecated; ignoring it...", this.getFilename(), value.getLine(), value.getColumn());
            return true;
        }
        if (key.equals("className")) {
            super.setOption(key, value);
            return true;
        }
        if (super.setOption(key, value)) {
            return true;
        }
        this.antxrTool.error("Invalid option: " + key, this.getFilename(), value.getLine(), value.getColumn());
        return false;
    }
}

