/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.CharScanner;
import com.javadude.antxr.RecognitionException;

public class NoViableAltForCharException
extends RecognitionException {
    private static final long serialVersionUID = 1L;
    public char foundChar;

    public NoViableAltForCharException(char c, CharScanner scanner) {
        super("NoViableAlt", scanner.getFilename(), scanner.getLine(), scanner.getColumn());
        this.foundChar = c;
    }

    public NoViableAltForCharException(char c, String fileName, int line) {
        this(c, fileName, line, -1);
    }

    public NoViableAltForCharException(char c, String fileName, int line, int column) {
        super("NoViableAlt", fileName, line, column);
        this.foundChar = c;
    }

    public String getMessage() {
        String mesg = "unexpected char: ";
        if (this.foundChar >= ' ' && this.foundChar <= '~') {
            mesg = String.valueOf(mesg) + '\'';
            mesg = String.valueOf(mesg) + this.foundChar;
            mesg = String.valueOf(mesg) + '\'';
        } else {
            mesg = String.valueOf(mesg) + "0x" + Integer.toHexString(this.foundChar).toUpperCase();
        }
        return mesg;
    }
}

