/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.ASTFactory;
import com.javadude.antxr.MismatchedTokenException;
import com.javadude.antxr.ParserSharedInputState;
import com.javadude.antxr.RecognitionException;
import com.javadude.antxr.Token;
import com.javadude.antxr.TokenBuffer;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.Utils;
import com.javadude.antxr.collections.AST;
import com.javadude.antxr.collections.impl.BitSet;
import java.util.Hashtable;

public abstract class Parser {
    protected ParserSharedInputState inputState;
    protected String[] tokenNames;
    protected AST returnAST;
    protected ASTFactory astFactory = null;
    protected Hashtable tokenTypeToASTClassMap = null;
    protected int traceDepth = 0;

    public Parser() {
        this(new ParserSharedInputState());
    }

    public Parser(ParserSharedInputState state) {
        this.inputState = state;
    }

    public Hashtable getTokenTypeToASTClassMap() {
        return this.tokenTypeToASTClassMap;
    }

    public abstract void consume() throws TokenStreamException;

    public void consumeUntil(int tokenType) throws TokenStreamException {
        while (this.LA(1) != 1 && this.LA(1) != tokenType) {
            this.consume();
        }
    }

    public void consumeUntil(BitSet set) throws TokenStreamException {
        while (this.LA(1) != 1 && !set.member(this.LA(1))) {
            this.consume();
        }
    }

    public AST getAST() {
        return this.returnAST;
    }

    public ASTFactory getASTFactory() {
        return this.astFactory;
    }

    public String getFilename() {
        return this.inputState.filename;
    }

    public ParserSharedInputState getInputState() {
        return this.inputState;
    }

    public void setInputState(ParserSharedInputState state) {
        this.inputState = state;
    }

    public String getTokenName(int num) {
        return this.tokenNames[num];
    }

    public String[] getTokenNames() {
        return this.tokenNames;
    }

    public boolean isDebugMode() {
        return false;
    }

    public abstract int LA(int var1) throws TokenStreamException;

    public abstract Token LT(int var1) throws TokenStreamException;

    public int mark() {
        return this.inputState.input.mark();
    }

    public void match(int t) throws MismatchedTokenException, TokenStreamException {
        if (this.LA(1) != t) {
            throw new MismatchedTokenException(this.tokenNames, this.LT(1), t, false, this.getFilename());
        }
        this.consume();
    }

    public void match(BitSet b) throws MismatchedTokenException, TokenStreamException {
        if (!b.member(this.LA(1))) {
            throw new MismatchedTokenException(this.tokenNames, this.LT(1), b, false, this.getFilename());
        }
        this.consume();
    }

    public void matchNot(int t) throws MismatchedTokenException, TokenStreamException {
        if (this.LA(1) == t) {
            throw new MismatchedTokenException(this.tokenNames, this.LT(1), t, true, this.getFilename());
        }
        this.consume();
    }

    public static void panic() {
        System.err.println("Parser: panic");
        Utils.error("");
    }

    public void reportError(RecognitionException ex) {
        System.err.println(ex);
    }

    public void reportError(String s) {
        if (this.getFilename() == null) {
            System.err.println("error: " + s);
        } else {
            System.err.println(String.valueOf(this.getFilename()) + ": error: " + s);
        }
    }

    public void reportWarning(String s) {
        if (this.getFilename() == null) {
            System.err.println("warning: " + s);
        } else {
            System.err.println(String.valueOf(this.getFilename()) + ": warning: " + s);
        }
    }

    public void recover(RecognitionException ex, BitSet tokenSet) throws TokenStreamException {
        this.consume();
        this.consumeUntil(tokenSet);
    }

    public void rewind(int pos) {
        this.inputState.input.rewind(pos);
    }

    public void setASTFactory(ASTFactory f) {
        this.astFactory = f;
    }

    public void setASTNodeClass(String cl) {
        this.astFactory.setASTNodeClass(cl);
    }

    public void setASTNodeType(String nodeType) {
        this.setASTNodeClass(nodeType);
    }

    public void setFilename(String f) {
        this.inputState.filename = f;
    }

    public void setTokenBuffer(TokenBuffer t) {
        this.inputState.input = t;
    }

    public void traceIndent() {
        int i = 0;
        while (i < this.traceDepth) {
            System.out.print(" ");
            ++i;
        }
    }

    public void traceIn(String rname) throws TokenStreamException {
        ++this.traceDepth;
        this.traceIndent();
        System.out.println("> " + rname + "; LA(1)==" + this.LT(1).getText() + (this.inputState.guessing > 0 ? " [guessing]" : ""));
    }

    public void traceOut(String rname) throws TokenStreamException {
        this.traceIndent();
        System.out.println("< " + rname + "; LA(1)==" + this.LT(1).getText() + (this.inputState.guessing > 0 ? " [guessing]" : ""));
        --this.traceDepth;
    }
}

