/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.AlternativeBlock;
import com.javadude.antxr.ExceptionSpec;
import com.javadude.antxr.Grammar;
import com.javadude.antxr.LexerGrammar;
import com.javadude.antxr.Lookahead;
import com.javadude.antxr.ParserGrammar;
import com.javadude.antxr.RuleEndElement;
import com.javadude.antxr.Token;
import com.javadude.antxr.TokenSymbol;
import com.javadude.antxr.collections.impl.Vector;
import java.util.Hashtable;

public class RuleBlock
extends AlternativeBlock {
    protected String ruleName;
    protected String argAction = null;
    protected String throwsSpec = null;
    protected String returnAction = null;
    protected RuleEndElement endNode;
    protected boolean testLiterals = false;
    Vector labeledElements;
    protected boolean[] lock;
    protected Lookahead[] cache;
    Hashtable exceptionSpecs;
    protected boolean defaultErrorHandler = true;
    protected String ignoreRule = null;

    public RuleBlock(Grammar g, String r) {
        super(g);
        this.ruleName = r;
        this.labeledElements = new Vector();
        this.cache = new Lookahead[g.maxk + 1];
        this.exceptionSpecs = new Hashtable();
        this.setAutoGen(g instanceof ParserGrammar);
    }

    public RuleBlock(Grammar g, String r, int line, boolean doAutoGen_) {
        this(g, r);
        this.line = line;
        this.setAutoGen(doAutoGen_);
    }

    public void addExceptionSpec(ExceptionSpec ex) {
        if (this.findExceptionSpec(ex.label) != null) {
            if (ex.label != null) {
                this.grammar.antxrTool.error("Rule '" + this.ruleName + "' already has an exception handler for label: " + ex.label);
            } else {
                this.grammar.antxrTool.error("Rule '" + this.ruleName + "' already has an exception handler");
            }
        } else {
            this.exceptionSpecs.put(ex.label == null ? "" : ex.label.getText(), ex);
        }
    }

    public ExceptionSpec findExceptionSpec(Token label) {
        return (ExceptionSpec)this.exceptionSpecs.get(label == null ? "" : label.getText());
    }

    public ExceptionSpec findExceptionSpec(String label) {
        return (ExceptionSpec)this.exceptionSpecs.get(label == null ? "" : label);
    }

    public void generate() {
        this.grammar.generator.gen(this);
    }

    public boolean getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public RuleEndElement getEndElement() {
        return this.endNode;
    }

    public String getIgnoreRule() {
        return this.ignoreRule;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public boolean getTestLiterals() {
        return this.testLiterals;
    }

    public boolean isLexerAutoGenRule() {
        return this.ruleName.equals("nextToken");
    }

    public Lookahead look(int k) {
        return this.grammar.theLLkAnalyzer.look(k, this);
    }

    public void prepareForAnalysis() {
        super.prepareForAnalysis();
        this.lock = new boolean[this.grammar.maxk + 1];
    }

    public void setDefaultErrorHandler(boolean value) {
        this.defaultErrorHandler = value;
    }

    public void setEndElement(RuleEndElement re) {
        this.endNode = re;
    }

    public void setOption(Token key, Token value) {
        if (key.getText().equals("defaultErrorHandler")) {
            if (value.getText().equals("true")) {
                this.defaultErrorHandler = true;
            } else if (value.getText().equals("false")) {
                this.defaultErrorHandler = false;
            } else {
                this.grammar.antxrTool.error("Value for defaultErrorHandler must be true or false", this.grammar.getFilename(), key.getLine(), key.getColumn());
            }
        } else if (key.getText().equals("testLiterals")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.antxrTool.error("testLiterals option only valid for lexer rules", this.grammar.getFilename(), key.getLine(), key.getColumn());
            } else if (value.getText().equals("true")) {
                this.testLiterals = true;
            } else if (value.getText().equals("false")) {
                this.testLiterals = false;
            } else {
                this.grammar.antxrTool.error("Value for testLiterals must be true or false", this.grammar.getFilename(), key.getLine(), key.getColumn());
            }
        } else if (key.getText().equals("ignore")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.antxrTool.error("ignore option only valid for lexer rules", this.grammar.getFilename(), key.getLine(), key.getColumn());
            } else {
                this.ignoreRule = value.getText();
            }
        } else if (key.getText().equals("paraphrase")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.antxrTool.error("paraphrase option only valid for lexer rules", this.grammar.getFilename(), key.getLine(), key.getColumn());
            } else {
                TokenSymbol ts = this.grammar.tokenManager.getTokenSymbol(this.ruleName);
                if (ts == null) {
                    this.grammar.antxrTool.fatalError("panic: cannot find token associated with rule " + this.ruleName);
                }
                ts.setParaphrase(value.getText());
            }
        } else if (key.getText().equals("generateAmbigWarnings")) {
            if (value.getText().equals("true")) {
                this.generateAmbigWarnings = true;
            } else if (value.getText().equals("false")) {
                this.generateAmbigWarnings = false;
            } else {
                this.grammar.antxrTool.error("Value for generateAmbigWarnings must be true or false", this.grammar.getFilename(), key.getLine(), key.getColumn());
            }
        } else if ("xmlTag".equals(key.getText())) {
            String text = value.getText();
            int begin = 0;
            int end = text.length();
            if (text.startsWith("\"")) {
                ++begin;
            }
            if (text.startsWith("<")) {
                ++begin;
            }
            if (text.endsWith("\"")) {
                --end;
            }
            if (text.endsWith(">")) {
                --end;
            }
            text = text.substring(begin, end);
            this.grammar.xmlRuleTagMap.put(this, this.resolveXMLName(this.grammar, text));
        } else {
            this.grammar.antxrTool.error("Invalid rule option: " + key.getText(), this.grammar.getFilename(), key.getLine(), key.getColumn());
        }
    }

    public String resolveXMLName(Grammar grammar, String tagName) {
        int colon = tagName.lastIndexOf(58);
        if (colon != -1 && colon != tagName.length() - 1) {
            String prefix = tagName.substring(0, colon);
            String tag = tagName.substring(colon + 1);
            String namespace = (String)grammar.namespaceMap.get(prefix);
            if (namespace != null) {
                return String.valueOf(namespace) + ":" + tag;
            }
        }
        return tagName;
    }

    public String toString() {
        String s = " FOLLOW={";
        Lookahead[] cache = this.endNode.cache;
        int k = this.grammar.maxk;
        boolean allNull = true;
        int j = 1;
        while (j <= k) {
            if (cache[j] != null) {
                s = String.valueOf(s) + cache[j].toString(",", this.grammar.tokenManager.getVocabulary());
                allNull = false;
                if (j < k && cache[j + 1] != null) {
                    s = String.valueOf(s) + ";";
                }
            }
            ++j;
        }
        s = String.valueOf(s) + "}";
        if (allNull) {
            s = "";
        }
        return String.valueOf(this.ruleName) + ": " + super.toString() + " ;" + s;
    }
}

