/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.Token;
import com.javadude.antxr.TokenQueue;
import com.javadude.antxr.TokenStream;
import com.javadude.antxr.TokenStreamException;

public class TokenBuffer {
    protected TokenStream input;
    int nMarkers = 0;
    int markerOffset = 0;
    int numToConsume = 0;
    TokenQueue queue;

    public TokenBuffer(TokenStream input_) {
        this.input = input_;
        this.queue = new TokenQueue(1);
    }

    public void reset() {
        this.nMarkers = 0;
        this.markerOffset = 0;
        this.numToConsume = 0;
        this.queue.reset();
    }

    public void consume() {
        ++this.numToConsume;
    }

    private void fill(int amount) throws TokenStreamException {
        this.syncConsume();
        while (this.queue.nbrEntries < amount + this.markerOffset) {
            this.queue.append(this.input.nextToken());
        }
    }

    public TokenStream getInput() {
        return this.input;
    }

    public int LA(int i) throws TokenStreamException {
        this.fill(i);
        return this.queue.elementAt(this.markerOffset + i - 1).getType();
    }

    public Token LT(int i) throws TokenStreamException {
        this.fill(i);
        return this.queue.elementAt(this.markerOffset + i - 1);
    }

    public int mark() {
        this.syncConsume();
        ++this.nMarkers;
        return this.markerOffset;
    }

    public void rewind(int mark) {
        this.syncConsume();
        this.markerOffset = mark;
        --this.nMarkers;
    }

    private void syncConsume() {
        while (this.numToConsume > 0) {
            if (this.nMarkers > 0) {
                ++this.markerOffset;
            } else {
                this.queue.removeFirst();
            }
            --this.numToConsume;
        }
    }
}

