/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr;

import com.javadude.antxr.ANTXRLexer;
import com.javadude.antxr.ANTXRParser;
import com.javadude.antxr.CodeGenerator;
import com.javadude.antxr.DefaultToolErrorHandler;
import com.javadude.antxr.FileCopyException;
import com.javadude.antxr.FileLineFormatter;
import com.javadude.antxr.LLkAnalyzer;
import com.javadude.antxr.MakeGrammar;
import com.javadude.antxr.PreservingFileWriter;
import com.javadude.antxr.RecognitionException;
import com.javadude.antxr.TokenBuffer;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.ToolErrorHandler;
import com.javadude.antxr.Utils;
import com.javadude.antxr.collections.impl.BitSet;
import com.javadude.antxr.collections.impl.Vector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.xml.utils.NameSpace;

public class Tool {
    public static String version = "";
    ToolErrorHandler errorHandler;
    protected boolean hasError = false;
    boolean genDiagnostics = false;
    boolean genDocBook = false;
    boolean genHTML = false;
    protected String outputDir = ".";
    protected String grammarFile;
    transient Reader f = new InputStreamReader(System.in);
    protected String literalsPrefix = "LITERAL_";
    protected boolean upperCaseMangledLiterals = false;
    protected NameSpace nameSpace = null;
    protected String namespaceAntxr = null;
    protected String namespaceStd = null;
    protected boolean genHashLines = true;
    protected boolean noConstructors = false;
    private BitSet cmdLineArgValid = new BitSet();

    public Tool() {
        this.errorHandler = new DefaultToolErrorHandler(this);
    }

    public String getGrammarFile() {
        return this.grammarFile;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public String getNamespaceStd() {
        return this.namespaceStd;
    }

    public String getNamespaceAntxr() {
        return this.namespaceAntxr;
    }

    public boolean getGenHashLines() {
        return this.genHashLines;
    }

    public String getLiteralsPrefix() {
        return this.literalsPrefix;
    }

    public boolean getUpperCaseMangledLiterals() {
        return this.upperCaseMangledLiterals;
    }

    public void setFileLineFormatter(FileLineFormatter formatter) {
        FileLineFormatter.setFormatter(formatter);
    }

    protected void checkForInvalidArguments(String[] args, BitSet cmdLineArgValid) {
        int a = 0;
        while (a < args.length) {
            if (!cmdLineArgValid.member(a)) {
                this.warning("invalid command-line argument: " + args[a] + "; ignored");
            }
            ++a;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(String source_name, String dest_name) throws IOException {
        Writer destination;
        block19: {
            File source_file = new File(source_name);
            File destination_file = new File(dest_name);
            Reader source = null;
            destination = null;
            try {
                int bytes_read;
                if (!source_file.exists()) throw new FileCopyException("FileCopy: no such source file: " + source_name);
                if (!source_file.isFile()) {
                    throw new FileCopyException("FileCopy: no such source file: " + source_name);
                }
                if (!source_file.canRead()) {
                    throw new FileCopyException("FileCopy: source file is unreadable: " + source_name);
                }
                if (destination_file.exists()) {
                    if (!destination_file.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + dest_name);
                    if (!destination_file.canWrite()) {
                        throw new FileCopyException("FileCopy: destination file is unwriteable: " + dest_name);
                    }
                } else {
                    File parentdir = this.parent(destination_file);
                    if (!parentdir.exists()) {
                        throw new FileCopyException("FileCopy: destination directory doesn't exist: " + dest_name);
                    }
                    if (!parentdir.canWrite()) {
                        throw new FileCopyException("FileCopy: destination directory is unwriteable: " + dest_name);
                    }
                }
                source = new BufferedReader(new FileReader(source_file));
                destination = new BufferedWriter(new FileWriter(destination_file));
                char[] buffer = new char[1024];
                while ((bytes_read = source.read(buffer, 0, 1024)) != -1) {
                    destination.write(buffer, 0, bytes_read);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destination == null) throw throwable;
                try {
                    destination.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (source == null) break block19;
            }
            try {}
            catch (IOException iOException) {}
            source.close();
        }
        if (destination == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }

    public int doEverything(String[] args) {
        com.javadude.antxr.preprocessor.Tool preTool = new com.javadude.antxr.preprocessor.Tool(this, args);
        boolean preprocess_ok = preTool.preprocess();
        String[] modifiedArgs = preTool.preprocessedArgList();
        this.processArguments(modifiedArgs);
        if (!preprocess_ok) {
            return 1;
        }
        this.f = this.getGrammarReader();
        ANTXRLexer lexer = new ANTXRLexer(this.f);
        TokenBuffer tokenBuf = new TokenBuffer(lexer);
        LLkAnalyzer analyzer = new LLkAnalyzer(this);
        MakeGrammar behavior = new MakeGrammar(this, args, analyzer);
        try {
            ANTXRParser p = new ANTXRParser(tokenBuf, behavior, this);
            p.setFilename(this.grammarFile);
            p.grammar();
            if (this.hasError()) {
                this.fatalError("Exiting due to errors.");
            }
            this.checkForInvalidArguments(modifiedArgs, this.cmdLineArgValid);
            String codeGenClassName = "com.javadude.antxr." + this.getLanguage(behavior) + "CodeGenerator";
            try {
                CodeGenerator codeGen = (CodeGenerator)Utils.createInstanceOf(codeGenClassName);
                codeGen.setBehavior(behavior);
                codeGen.setAnalyzer(analyzer);
                codeGen.setTool(this);
                codeGen.gen();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.fatalError("panic: Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (InstantiationException instantiationException) {
                this.fatalError("panic: Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fatalError("panic: Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.fatalError("panic: code-generator class '" + codeGenClassName + "' is not accessible");
            }
        }
        catch (RecognitionException pe) {
            this.fatalError("Unhandled parser error: " + pe.getMessage());
        }
        catch (TokenStreamException io) {
            this.fatalError("TokenStreamException: " + io.getMessage());
        }
        return 0;
    }

    public void error(String s) {
        this.hasError = true;
        System.err.println("error: " + s);
    }

    public void error(String s, String file, int line, int column) {
        this.hasError = true;
        System.err.println(String.valueOf(FileLineFormatter.getFormatter().getFormatString(file, line, column)) + s);
    }

    public Object factory(String p) {
        Object o = null;
        try {
            o = Utils.createInstanceOf(p);
        }
        catch (Exception exception) {
            this.warning("Can't create an object of type " + p);
            return null;
        }
        return o;
    }

    public String fileMinusPath(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return f;
        }
        return f.substring(endOfPath + 1);
    }

    public String getLanguage(MakeGrammar behavior) {
        if (this.genDiagnostics) {
            return "Diagnostic";
        }
        if (this.genHTML) {
            return "HTML";
        }
        if (this.genDocBook) {
            return "DocBook";
        }
        return behavior.language;
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    private static void help() {
        System.err.println("usage: java com.javadude.antxr.Tool [args] file.g");
        System.err.println("  -o outputDir       specify output directory where all output generated.");
        System.err.println("  -glib superGrammar specify location of supergrammar file.");
        System.err.println("  -smap              generate a JSR-45 compliant source map to walk a grammar in a debugger.");
        System.err.println("  -debug             add ParseView support to your generated parser (Parseview will when you run your application).");
        System.err.println("  -html              generate a html file from your grammar.");
        System.err.println("  -docbook           generate a docbook sgml file from your grammar.");
        System.err.println("  -diagnostic        generate a textfile with diagnostics.");
        System.err.println("  -trace             have all rules call traceIn/traceOut.");
        System.err.println("  -traceLexer        have lexer rules call traceIn/traceOut.");
        System.err.println("  -traceParser       have parser rules call traceIn/traceOut.");
        System.err.println("  -traceTreeParser   have tree parser rules call traceIn/traceOut.");
        System.err.println("  -plugin            specify a special plugin class (see the plugin's documentation for usage).");
        System.err.println("  -h|-help|--help    this message");
    }

    public static void main(String[] args) {
        System.err.println("ANTXR Parser Generator   Version 2.7.6rc1 (2005-04-17)   1989-2005 jGuru.com");
        version = "2.7.6rc1 (2005-04-17)";
        try {
            boolean showHelp = false;
            if (args.length == 0) {
                showHelp = true;
            } else {
                int i = 0;
                while (i < args.length) {
                    if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("--help")) {
                        showHelp = true;
                        break;
                    }
                    ++i;
                }
            }
            if (showHelp) {
                Tool.help();
            } else {
                Tool theTool = new Tool();
                theTool.doEverything(args);
                Object var2_4 = null;
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator"));
            System.err.println("#$%%*&@# internal error: " + e.toString());
            System.err.println("[complain to nearest government official");
            System.err.println(" or send hate-mail to parrt@jguru.com;");
            System.err.println(" please send stack trace with report.]" + System.getProperty("line.separator"));
            e.printStackTrace();
        }
    }

    public PrintWriter openOutputFile(String f) throws IOException {
        File out_dir;
        if (this.outputDir != "." && !(out_dir = new File(this.outputDir)).exists()) {
            out_dir.mkdirs();
        }
        return new PrintWriter(new PreservingFileWriter(String.valueOf(this.outputDir) + System.getProperty("file.separator") + f));
    }

    public Reader getGrammarReader() {
        BufferedReader f = null;
        try {
            if (this.grammarFile != null) {
                f = new BufferedReader(new FileReader(this.grammarFile));
            }
        }
        catch (IOException iOException) {
            this.fatalError("cannot open grammar file " + this.grammarFile);
        }
        return f;
    }

    public void reportException(Exception e, String message) {
        System.err.println(message == null ? e.getMessage() : String.valueOf(message) + ": " + e.getMessage());
    }

    public void reportProgress(String message) {
        System.out.println(message);
    }

    public void fatalError(String message) {
        System.err.println(message);
        Utils.error(message);
    }

    public void panic() {
        this.fatalError("panic");
    }

    public void panic(String s) {
        this.fatalError("panic: " + s);
    }

    public File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    public static Vector parseSeparatedList(String list, char separator) {
        StringTokenizer st = new StringTokenizer(list, String.valueOf(separator));
        Vector v = new Vector(10);
        while (st.hasMoreTokens()) {
            v.appendElement(st.nextToken());
        }
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    public String pathToFile(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return "." + System.getProperty("file.separator");
        }
        return f.substring(0, endOfPath + 1);
    }

    protected void processArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-diagnostic")) {
                this.genDiagnostics = true;
                this.genHTML = false;
                this.setArgOK(i);
            } else if (args[i].equals("-o")) {
                this.setArgOK(i);
                if (i + 1 >= args.length) {
                    this.error("missing output directory with -o option; ignoring");
                } else {
                    this.setOutputDirectory(args[++i]);
                    this.setArgOK(i);
                }
            } else if (args[i].equals("-html")) {
                this.genHTML = true;
                this.genDiagnostics = false;
                this.setArgOK(i);
            } else if (args[i].equals("-docbook")) {
                this.genDocBook = true;
                this.genDiagnostics = false;
                this.setArgOK(i);
            } else if (args[i].charAt(0) != '-') {
                this.grammarFile = args[i];
                this.setArgOK(i);
            }
            ++i;
        }
    }

    public void setArgOK(int i) {
        this.cmdLineArgValid.add(i);
    }

    public void setOutputDirectory(String o) {
        this.outputDir = o;
    }

    public void toolError(String s) {
        System.err.println("error: " + s);
    }

    public void warning(String s) {
        System.err.println("warning: " + s);
    }

    public void warning(String s, String file, int line, int column) {
        System.err.println(String.valueOf(FileLineFormatter.getFormatter().getFormatString(file, line, column)) + "warning:" + s);
    }

    public void warning(String[] s, String file, int line, int column) {
        if (s == null || s.length == 0) {
            this.fatalError("panic: bad multi-line message to Tool.warning");
        }
        System.err.println(String.valueOf(FileLineFormatter.getFormatter().getFormatString(file, line, column)) + "warning:" + s[0]);
        int i = 1;
        while (i < s.length) {
            System.err.println(String.valueOf(FileLineFormatter.getFormatter().getFormatString(file, line, column)) + "    " + s[i]);
            ++i;
        }
    }
}

