/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.debug;

import com.javadude.antxr.CharScanner;
import com.javadude.antxr.CharStreamException;
import com.javadude.antxr.InputBuffer;
import com.javadude.antxr.LexerSharedInputState;
import com.javadude.antxr.MismatchedCharException;
import com.javadude.antxr.Token;
import com.javadude.antxr.collections.impl.BitSet;
import com.javadude.antxr.debug.DebuggingParser;
import com.javadude.antxr.debug.ParserEventSupport;
import com.javadude.antxr.debug.ParserListener;

public abstract class DebuggingCharScanner
extends CharScanner
implements DebuggingParser {
    private ParserEventSupport parserEventSupport = new ParserEventSupport(this);
    private String[] ruleNames;
    private String[] semPredNames;

    public String getTokenName(int num) {
        throw new UnsupportedOperationException();
    }

    public DebuggingCharScanner(InputBuffer cb) {
        super(cb);
    }

    public DebuggingCharScanner(LexerSharedInputState state) {
        super(state);
    }

    public void addParserListener(ParserListener l) {
        this.parserEventSupport.addParserListener(l);
    }

    public void consume() throws CharStreamException {
        int la_1 = -99;
        try {
            la_1 = this.LA(1);
        }
        catch (CharStreamException charStreamException) {}
        super.consume();
        this.parserEventSupport.fireConsume(la_1, this.inputState.guessing);
    }

    public String getRuleName(int num) {
        return this.ruleNames[num];
    }

    public String getSemPredName(int num) {
        return this.semPredNames[num];
    }

    public synchronized void goToSleep() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public char LA(int i) throws CharStreamException {
        char la = super.LA(i);
        this.parserEventSupport.fireLA(i, la);
        return la;
    }

    protected Token makeToken(int t) {
        return super.makeToken(t);
    }

    public void match(char c) throws MismatchedCharException, CharStreamException {
        char la_1 = this.LA(1);
        try {
            super.match(c);
            this.parserEventSupport.fireMatch(la_1, c, (String)null, this.inputState.guessing, false, true);
        }
        catch (MismatchedCharException e) {
            this.parserEventSupport.fireMatch(la_1, c, (String)null, this.inputState.guessing, false, false);
            throw e;
        }
    }

    public void match(BitSet b) throws MismatchedCharException, CharStreamException {
        String text = this.text.toString();
        char la_1 = this.LA(1);
        try {
            super.match(b);
            this.parserEventSupport.fireMatch(la_1, b, text, this.inputState.guessing, false, true);
        }
        catch (MismatchedCharException e) {
            this.parserEventSupport.fireMatch(la_1, b, text, this.inputState.guessing, false, false);
            throw e;
        }
    }

    public void match(String s) throws MismatchedCharException, CharStreamException {
        StringBuffer la_s = new StringBuffer("");
        int len = s.length();
        try {
            int i = 1;
            while (i <= len) {
                la_s.append(super.LA(i));
                ++i;
            }
        }
        catch (Exception exception) {}
        try {
            super.match(s);
            this.parserEventSupport.fireMatch(la_s.toString(), s, s, this.inputState.guessing, false, true);
        }
        catch (MismatchedCharException e) {
            this.parserEventSupport.fireMatch(la_s.toString(), s, s, this.inputState.guessing, false, false);
            throw e;
        }
    }

    public void matchNot(char c) throws MismatchedCharException, CharStreamException {
        char la_1 = this.LA(1);
        try {
            super.matchNot(c);
            this.parserEventSupport.fireMatch(la_1, c, (String)null, this.inputState.guessing, true, true);
        }
        catch (MismatchedCharException e) {
            this.parserEventSupport.fireMatch(la_1, c, (String)null, this.inputState.guessing, true, false);
            throw e;
        }
    }

    public void matchRange(char c1, char c2) throws MismatchedCharException, CharStreamException {
        char la_1 = this.LA(1);
        String range = String.valueOf(c1) + "-" + c2;
        try {
            super.matchRange(c1, c2);
            this.parserEventSupport.fireMatch(la_1, range, range, this.inputState.guessing, false, true);
        }
        catch (MismatchedCharException e) {
            this.parserEventSupport.fireMatch(la_1, range, range, this.inputState.guessing, false, false);
            throw e;
        }
    }

    public void newline() {
        super.newline();
        this.parserEventSupport.fireNewLine(this.getLine());
    }

    public void removeParserListener(ParserListener l) {
        this.parserEventSupport.removeParserListener(l);
    }

    public void reportError(MismatchedCharException e) {
        this.parserEventSupport.fireReportError(e);
        super.reportError(e);
    }

    public void reportError(String s) {
        this.parserEventSupport.fireReportError(s);
        super.reportError(s);
    }

    public void reportWarning(String s) {
        this.parserEventSupport.fireReportWarning(s);
        super.reportWarning(s);
    }

    public void setupDebugging(String[] ruleNames, String[] semPredNames) {
        this.ruleNames = ruleNames;
        this.semPredNames = semPredNames;
    }

    public synchronized void wakeUp() {
        this.notifyAll();
    }

    public void fireConsume(int value) {
        this.parserEventSupport.fireConsume(value, this.inputState.guessing);
    }

    public void fireDoneParsing() {
        this.parserEventSupport.fireDoneParsing();
    }

    public void fireEnterRule(int ruleNum, int data) {
        this.parserEventSupport.fireEnterRule(ruleNum, this.inputState.guessing, data);
    }

    public void fireExitRule(int ruleNum, int data) {
        this.parserEventSupport.fireExitRule(ruleNum, this.inputState.guessing, data);
    }

    public void fireLA(int k, int la) {
        this.parserEventSupport.fireLA(k, la);
    }

    public void fireLT(int k, Token lt) {
        this.parserEventSupport.fireLT(k, lt);
    }

    public void fireMatch(char value, BitSet expected, String text, boolean inverse, boolean matched) {
        this.parserEventSupport.fireMatch(value, expected, text, this.inputState.guessing, inverse, matched);
    }

    public void fireMatch(char value, char expected, String text, boolean inverse, boolean matched) {
        this.parserEventSupport.fireMatch(value, expected, text, this.inputState.guessing, inverse, matched);
    }

    public void fireMatch(char value, String expected, String text, boolean inverse, boolean matched) {
        this.parserEventSupport.fireMatch(value, expected, text, this.inputState.guessing, inverse, matched);
    }

    public void fireMatch(int value, BitSet expected, String text, boolean inverse, boolean matched) {
        this.parserEventSupport.fireMatch(value, expected, text, this.inputState.guessing, inverse, matched);
    }

    public void fireMatch(int token, int expected, String text, boolean inverse, boolean matched) {
        this.parserEventSupport.fireMatch(token, expected, text, this.inputState.guessing, inverse, matched);
    }

    public void fireMatch(String s, String expected, String text, boolean inverse, boolean matched) {
        this.parserEventSupport.fireMatch(s, expected, text, this.inputState.guessing, inverse, matched);
    }

    public void fireNewLine(int line) {
        this.parserEventSupport.fireNewLine(line);
    }

    public void fireReportError(String s) {
        this.parserEventSupport.fireReportError(s);
    }

    public void fireReportError(Throwable throwable) {
        this.parserEventSupport.fireReportError(throwable);
    }

    public void fireReportWarning(String s) {
        this.parserEventSupport.fireReportWarning(s);
    }

    public boolean fireSemanticPredicateEvaluated(boolean validating, int condition, boolean result) {
        return this.parserEventSupport.fireSemanticPredicateEvaluated(validating, condition, result, this.inputState.guessing);
    }

    public void fireSyntacticPredicateFinished(boolean succeeded) {
        this.parserEventSupport.fireSyntacticPredicateFinished(this.inputState.guessing, succeeded);
    }

    public void fireSyntacticPredicateStarted() {
        this.parserEventSupport.fireSyntacticPredicateStarted(this.inputState.guessing);
    }
}

