/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.debug;

import com.javadude.antxr.CommonToken;
import com.javadude.antxr.LLkParser;
import com.javadude.antxr.MismatchedTokenException;
import com.javadude.antxr.ParseTree;
import com.javadude.antxr.ParseTreeRule;
import com.javadude.antxr.ParseTreeToken;
import com.javadude.antxr.ParserSharedInputState;
import com.javadude.antxr.TokenBuffer;
import com.javadude.antxr.TokenStream;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.collections.impl.BitSet;
import java.util.Stack;

public class ParseTreeDebugParser
extends LLkParser {
    protected Stack currentParseTreeRoot = new Stack();
    protected ParseTreeRule mostRecentParseTreeRoot = null;
    protected int numberOfDerivationSteps = 1;

    public ParseTreeDebugParser(int k_) {
        super(k_);
    }

    public ParseTreeDebugParser(ParserSharedInputState state, int k_) {
        super(state, k_);
    }

    public ParseTreeDebugParser(TokenBuffer tokenBuf, int k_) {
        super(tokenBuf, k_);
    }

    public ParseTreeDebugParser(TokenStream lexer, int k_) {
        super(lexer, k_);
    }

    public ParseTree getParseTree() {
        return this.mostRecentParseTreeRoot;
    }

    public int getNumberOfDerivationSteps() {
        return this.numberOfDerivationSteps;
    }

    public void match(int i) throws MismatchedTokenException, TokenStreamException {
        this.addCurrentTokenToParseTree();
        super.match(i);
    }

    public void match(BitSet bitSet) throws MismatchedTokenException, TokenStreamException {
        this.addCurrentTokenToParseTree();
        super.match(bitSet);
    }

    public void matchNot(int i) throws MismatchedTokenException, TokenStreamException {
        this.addCurrentTokenToParseTree();
        super.matchNot(i);
    }

    protected void addCurrentTokenToParseTree() throws TokenStreamException {
        if (this.inputState.guessing > 0) {
            return;
        }
        ParseTreeRule root = (ParseTreeRule)this.currentParseTreeRoot.peek();
        ParseTreeToken tokenNode = null;
        tokenNode = this.LA(1) == 1 ? new ParseTreeToken(new CommonToken("EOF")) : new ParseTreeToken(this.LT(1));
        root.addChild(tokenNode);
    }

    public void traceIn(String s) throws TokenStreamException {
        if (this.inputState.guessing > 0) {
            return;
        }
        ParseTreeRule subRoot = new ParseTreeRule(s);
        if (this.currentParseTreeRoot.size() > 0) {
            ParseTreeRule oldRoot = (ParseTreeRule)this.currentParseTreeRoot.peek();
            oldRoot.addChild(subRoot);
        }
        this.currentParseTreeRoot.push(subRoot);
        ++this.numberOfDerivationSteps;
    }

    public void traceOut(String s) throws TokenStreamException {
        if (this.inputState.guessing > 0) {
            return;
        }
        this.mostRecentParseTreeRoot = (ParseTreeRule)this.currentParseTreeRoot.pop();
    }
}

