/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.debug;

import com.javadude.antxr.Token;
import com.javadude.antxr.collections.impl.BitSet;
import com.javadude.antxr.debug.DebuggingParser;
import com.javadude.antxr.debug.ParserListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ParserEventSupport {
    private List parserListeners = new ArrayList();
    private DebuggingParser parser;
    private int ruleDepth = 0;

    public ParserEventSupport(DebuggingParser parser) {
        this.parser = parser;
    }

    public void addParserListener(ParserListener l) {
        this.parserListeners.add(l);
    }

    public void removeParserListener(ParserListener l) {
        this.parserListeners.remove(l);
    }

    public void fireConsume(int value, int guessing) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserConsume(this.parser, value, guessing);
        }
    }

    public void fireDoneParsing() {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.doneParsing(this.parser);
        }
    }

    public void fireEnterRule(int ruleNum, int guessing, int data) {
        ++this.ruleDepth;
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.enterRule(this.parser, ruleNum, guessing, data);
        }
    }

    public void fireExitRule(int ruleNum, int guessing, int data) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.exitRule(this.parser, ruleNum, guessing, data);
        }
        --this.ruleDepth;
        if (this.ruleDepth == 0) {
            this.fireDoneParsing();
        }
    }

    public void fireLA(int k, int la) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserLA(this.parser, k, la);
        }
    }

    public void fireLT(int k, Token lt) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserLT(this.parser, k, lt);
        }
    }

    public void fireMatch(char value, char expected, String text, int guessing, boolean inverse, boolean matched) {
        Character target = null;
        if (!matched) {
            target = new Character(expected);
        }
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserMatch(this.parser, 2, value, (Object)target, text, guessing, inverse, matched);
        }
    }

    public void fireMatch(char value, BitSet expected, String text, int guessing, boolean inverse, boolean matched) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserMatch(this.parser, 3, value, (Object)expected, text, guessing, inverse, matched);
        }
    }

    public void fireMatch(char value, String expected, String text, int guessing, boolean inverse, boolean matched) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserMatch(this.parser, 5, value, (Object)expected, text, guessing, inverse, matched);
        }
    }

    public void fireMatch(int value, BitSet expected, String text, int guessing, boolean inverse, boolean matched) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserMatch(this.parser, 1, value, (Object)expected, text, guessing, inverse, matched);
        }
    }

    public void fireMatch(int token, int expected, String text, int guessing, boolean inverse, boolean matched) {
        Integer target = null;
        if (!matched) {
            target = new Integer(expected);
        }
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserMatch(this.parser, 0, token, (Object)target, text, guessing, inverse, matched);
        }
    }

    public void fireMatch(String s, String expected, String text, int guessing, boolean inverse, boolean matched) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.parserMatch(this.parser, 4, s, (Object)expected, text, guessing, inverse, matched);
        }
    }

    public void fireNewLine(int line) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.hitNewLine(this.parser, line);
        }
    }

    public void fireReportError(Throwable throwable) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.reportError(this.parser, throwable);
        }
    }

    public void fireReportError(String s) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.reportError(this.parser, s);
        }
    }

    public void fireReportWarning(String s) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.reportWarning(this.parser, s);
        }
    }

    public boolean fireSemanticPredicateEvaluated(boolean validating, int condition, boolean result, int guessing) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.semanticPredicateEvaluated(this.parser, validating, condition, result, guessing);
        }
        return result;
    }

    public void fireSyntacticPredicateStarted(int guessing) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.syntacticPredicateStarted(this.parser, guessing);
        }
    }

    public void fireSyntacticPredicateFinished(int guessing, boolean succeeded) {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.syntacticPredicateFinished(this.parser, guessing, succeeded);
        }
    }

    public void fireRefresh() {
        Iterator i = this.parserListeners.iterator();
        while (i.hasNext()) {
            ParserListener p = (ParserListener)i.next();
            p.refresh(this.parser);
        }
    }
}

