/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.debug.misc;

import com.javadude.antxr.ASTFactory;
import com.javadude.antxr.CommonAST;
import com.javadude.antxr.collections.AST;
import com.javadude.antxr.debug.misc.JTreeASTModel;
import com.javadude.antxr.debug.misc.JTreeASTPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ASTFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    static final int WIDTH = 200;
    static final int HEIGHT = 300;

    public ASTFrame(String lab, AST r) {
        super(lab);
        new MyTreeSelectionListener();
        JTreeASTPanel tp = new JTreeASTPanel(new JTreeASTModel(r), null);
        Container content = this.getContentPane();
        content.add((Component)tp, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Frame f = (Frame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        this.setSize(200, 300);
    }

    public static void main(String[] args) {
        ASTFactory factory = new ASTFactory();
        CommonAST r = (CommonAST)factory.create(0, "ROOT");
        r.addChild(factory.create(0, "C1"));
        r.addChild(factory.create(0, "C2"));
        r.addChild(factory.create(0, "C3"));
        ASTFrame frame = new ASTFrame("AST JTree Example", r);
        frame.setVisible(true);
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            TreePath path = event.getPath();
            System.out.println("Selected: " + path.getLastPathComponent());
            Object[] elements = path.getPath();
            int i = 0;
            while (i < elements.length) {
                System.out.print("->" + elements[i]);
                ++i;
            }
            System.out.println();
        }
    }
}

