/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.preprocessor;

import com.javadude.antxr.ANTXRException;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.Tool;
import com.javadude.antxr.collections.impl.IndexedVector;
import com.javadude.antxr.preprocessor.Grammar;
import com.javadude.antxr.preprocessor.GrammarFile;
import com.javadude.antxr.preprocessor.Preprocessor;
import com.javadude.antxr.preprocessor.PreprocessorLexer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Hierarchy {
    protected Grammar LexerRoot = null;
    protected Grammar ParserRoot = null;
    protected Grammar TreeParserRoot = null;
    protected Hashtable symbols;
    protected Hashtable files;
    protected Tool antxrTool;

    public Hierarchy(Tool tool) {
        this.antxrTool = tool;
        this.LexerRoot = new Grammar(tool, "Lexer", null, null);
        this.ParserRoot = new Grammar(tool, "Parser", null, null);
        this.TreeParserRoot = new Grammar(tool, "TreeParser", null, null);
        this.symbols = new Hashtable(10);
        this.files = new Hashtable(10);
        this.LexerRoot.setPredefined(true);
        this.ParserRoot.setPredefined(true);
        this.TreeParserRoot.setPredefined(true);
        this.symbols.put(this.LexerRoot.getName(), this.LexerRoot);
        this.symbols.put(this.ParserRoot.getName(), this.ParserRoot);
        this.symbols.put(this.TreeParserRoot.getName(), this.TreeParserRoot);
    }

    public void addGrammar(Grammar gr) {
        gr.setHierarchy(this);
        this.symbols.put(gr.getName(), gr);
        GrammarFile f = this.getFile(gr.getFileName());
        f.addGrammar(gr);
    }

    public void addGrammarFile(GrammarFile gf) {
        this.files.put(gf.getName(), gf);
    }

    public void expandGrammarsInFile(String fileName) {
        GrammarFile f = this.getFile(fileName);
        Enumeration e = f.getGrammars().elements();
        while (e.hasMoreElements()) {
            Grammar g = (Grammar)e.nextElement();
            g.expandInPlace();
        }
    }

    public Grammar findRoot(Grammar g) {
        if (g.getSuperGrammarName() == null) {
            return g;
        }
        Grammar sg = g.getSuperGrammar();
        if (sg == null) {
            return g;
        }
        return this.findRoot(sg);
    }

    public GrammarFile getFile(String fileName) {
        return (GrammarFile)this.files.get(fileName);
    }

    public Grammar getGrammar(String gr) {
        return (Grammar)this.symbols.get(gr);
    }

    public static String optionsToString(IndexedVector options) {
        String s = "options {" + System.getProperty("line.separator");
        Enumeration e = options.elements();
        while (e.hasMoreElements()) {
            s = String.valueOf(s) + e.nextElement() + System.getProperty("line.separator");
        }
        s = String.valueOf(s) + "}" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return s;
    }

    public void readGrammarFile(String file) throws FileNotFoundException {
        BufferedReader grStream = new BufferedReader(new FileReader(file));
        this.addGrammarFile(new GrammarFile(this.antxrTool, file));
        PreprocessorLexer ppLexer = new PreprocessorLexer(grStream);
        ppLexer.setFilename(file);
        Preprocessor pp = new Preprocessor(ppLexer);
        pp.setHierarchy(this);
        pp.setGrammarFileBeingRead(file);
        pp.setTool(this.antxrTool);
        pp.setFilename(file);
        try {
            pp.grammarFile(this, file);
        }
        catch (TokenStreamException io) {
            this.antxrTool.toolError("Token stream error reading grammar(s):\n" + io);
        }
        catch (ANTXRException se) {
            this.antxrTool.toolError("error reading grammar(s):\n" + se);
        }
    }

    public boolean verifyThatHierarchyIsComplete() {
        Grammar c;
        boolean complete = true;
        Enumeration e = this.symbols.elements();
        while (e.hasMoreElements()) {
            Grammar superG;
            c = (Grammar)e.nextElement();
            if (c.getSuperGrammarName() == null || (superG = c.getSuperGrammar()) != null) continue;
            this.antxrTool.toolError("grammar " + c.getSuperGrammarName() + " not defined");
            complete = false;
            this.symbols.remove(c.getName());
        }
        if (!complete) {
            return false;
        }
        e = this.symbols.elements();
        while (e.hasMoreElements()) {
            c = (Grammar)e.nextElement();
            if (c.getSuperGrammarName() == null) continue;
            c.setType(this.findRoot(c).getName());
        }
        return true;
    }

    public Tool getTool() {
        return this.antxrTool;
    }

    public void setTool(Tool antxrTool) {
        this.antxrTool = antxrTool;
    }
}

