/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.preprocessor;

import com.javadude.antxr.LLkParser;
import com.javadude.antxr.NoViableAltException;
import com.javadude.antxr.ParserSharedInputState;
import com.javadude.antxr.RecognitionException;
import com.javadude.antxr.SemanticException;
import com.javadude.antxr.Token;
import com.javadude.antxr.TokenBuffer;
import com.javadude.antxr.TokenStream;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.Tool;
import com.javadude.antxr.collections.impl.BitSet;
import com.javadude.antxr.collections.impl.IndexedVector;
import com.javadude.antxr.preprocessor.Grammar;
import com.javadude.antxr.preprocessor.Hierarchy;
import com.javadude.antxr.preprocessor.Option;
import com.javadude.antxr.preprocessor.PreprocessorTokenTypes;
import com.javadude.antxr.preprocessor.Rule;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class Preprocessor
extends LLkParser
implements PreprocessorTokenTypes {
    private static Map __xml_namespaceMap = new HashMap();
    private String grammarFileBeingRead;
    private Hierarchy hierarchy;
    private Tool antxrTool;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"tokens\"", "HEADER_ACTION", "SUBRULE_BLOCK", "ACTION", "\"class\"", "ID", "\"extends\"", "SEMI", "TOKENS_SPEC", "OPTIONS_START", "ASSIGN_RHS", "RCURLY", "\"protected\"", "\"private\"", "\"public\"", "BANG", "ARG_ACTION", "\"returns\"", "RULE_BLOCK", "\"throws\"", "COMMA", "\"exception\"", "\"catch\"", "ALT", "ELEMENT", "LPAREN", "RPAREN", "ID_OR_KEYWORD", "CURLY_BLOCK_SCARF", "WS", "NEWLINE", "COMMENT", "SL_COMMENT", "ML_COMMENT", "CHAR_LITERAL", "STRING_LITERAL", "ESC", "DIGIT", "XDIGIT"};
    public static final BitSet _tokenSet_0 = new BitSet(Preprocessor.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(Preprocessor.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(Preprocessor.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(Preprocessor.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(Preprocessor.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(Preprocessor.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(Preprocessor.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(Preprocessor.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(Preprocessor.mk_tokenSet_8());

    public static Map getNamespaceMap() {
        return __xml_namespaceMap;
    }

    public static String resolveNamespace(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return "";
        }
        return (String)__xml_namespaceMap.get(prefix);
    }

    public void setGrammarFileBeingRead(String g) {
        this.grammarFileBeingRead = g;
    }

    public void setHierarchy(Hierarchy h) {
        this.hierarchy = h;
    }

    public void setTool(Tool tool) {
        if (this.antxrTool != null) {
            throw new IllegalStateException("com.javadude.antxr.Tool already registered");
        }
        this.antxrTool = tool;
    }

    protected Tool getTool() {
        return this.antxrTool;
    }

    public void reportError(String s) {
        if (this.getTool() != null) {
            this.getTool().error(s, this.getFilename(), -1, -1);
        } else {
            super.reportError(s);
        }
    }

    public void reportError(RecognitionException e) {
        if (this.getTool() != null) {
            this.getTool().error(e.getErrorMessage(), e.getFilename(), e.getLine(), e.getColumn());
        } else {
            super.reportError(e);
        }
    }

    public void reportWarning(String s) {
        if (this.getTool() != null) {
            this.getTool().warning(s, this.getFilename(), -1, -1);
        } else {
            super.reportWarning(s);
        }
    }

    protected Preprocessor(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public Preprocessor(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected Preprocessor(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public Preprocessor(TokenStream lexer) {
        this(lexer, 2);
    }

    public Preprocessor(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final void grammarFile(Hierarchy hier, String file) throws RecognitionException, TokenStreamException {
        Token hdr = null;
        IndexedVector opt = null;
        try {
            while (this.LA(1) == 5) {
                hdr = this.LT(1);
                this.match(5);
                hier.getFile(file).addHeaderAction(hdr.getText());
            }
            switch (this.LA(1)) {
                case 13: {
                    opt = this.optionSpec(null);
                    break;
                }
                case 1: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 7 || this.LA(1) == 8) {
                Grammar gr = this.class_def(file, hier);
                if (gr != null && opt != null) {
                    hier.getFile(file).setOptions(opt);
                }
                if (gr == null) continue;
                gr.setFileName(file);
                hier.addGrammar(gr);
            }
            this.match(1);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_0);
        }
    }

    public final IndexedVector optionSpec(Grammar gr) throws RecognitionException, TokenStreamException {
        Token op = null;
        Token rhs = null;
        IndexedVector options = new IndexedVector();
        try {
            this.match(13);
            while (this.LA(1) == 9) {
                op = this.LT(1);
                this.match(9);
                rhs = this.LT(1);
                this.match(14);
                Option newOp = new Option(op.getText(), rhs.getText(), gr);
                options.appendElement(newOp.getName(), newOp);
                if (gr != null && op.getText().equals("importVocab")) {
                    gr.specifiedVocabulary = true;
                    gr.importVocab = rhs.getText();
                    continue;
                }
                if (gr != null && op.getText().equals("exportVocab")) {
                    gr.exportVocab = rhs.getText().substring(0, rhs.getText().length() - 1);
                    gr.exportVocab = gr.exportVocab.trim();
                    continue;
                }
                if (gr == null || !op.getText().equals("superGrammarFile")) continue;
                String grammarFileName = rhs.getText();
                try {
                    File grammarFile;
                    grammarFileName = grammarFileName.trim();
                    int semi = grammarFileName.lastIndexOf(59);
                    if (semi != -1) {
                        grammarFileName = grammarFileName.substring(0, semi);
                    }
                    if (grammarFileName.startsWith("\"")) {
                        grammarFileName = grammarFileName.substring(1);
                    }
                    if (grammarFileName.endsWith("\"")) {
                        grammarFileName = grammarFileName.substring(0, grammarFileName.length() - 1);
                    }
                    if (!(grammarFile = new File(grammarFileName)).isAbsolute()) {
                        File ff = new File(this.grammarFileBeingRead);
                        ff = ff.getParentFile();
                        grammarFile = new File(ff, grammarFileName);
                    }
                    this.hierarchy.readGrammarFile(grammarFile.getAbsolutePath());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.reportError("Grammar file " + grammarFileName + " not found!!! grammarFile = " + this.grammarFileBeingRead);
                }
            }
            this.match(15);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_1);
        }
        return options;
    }

    public final Grammar class_def(String file, Hierarchy hier) throws RecognitionException, TokenStreamException {
        Token preamble = null;
        Token sub = null;
        Token sup = null;
        Token tk = null;
        Token memberA = null;
        Grammar gr = null;
        IndexedVector rules = new IndexedVector(100);
        IndexedVector classOptions = null;
        String sc = null;
        try {
            switch (this.LA(1)) {
                case 7: {
                    preamble = this.LT(1);
                    this.match(7);
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(8);
            sub = this.LT(1);
            this.match(9);
            this.match(10);
            sup = this.LT(1);
            this.match(9);
            switch (this.LA(1)) {
                case 6: {
                    sc = this.superClass();
                    break;
                }
                case 11: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(11);
            gr = hier.getGrammar(sub.getText());
            if (gr != null) {
                gr = null;
                throw new SemanticException("redefinition of grammar " + sub.getText(), file, sub.getLine(), sub.getColumn());
            }
            gr = new Grammar(hier.getTool(), sub.getText(), sup.getText(), rules);
            gr.superClass = sc;
            if (preamble != null) {
                gr.setPreambleAction(preamble.getText());
            }
            switch (this.LA(1)) {
                case 13: {
                    classOptions = this.optionSpec(gr);
                    break;
                }
                case 7: 
                case 9: 
                case 12: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            if (gr != null) {
                gr.setOptions(classOptions);
            }
            switch (this.LA(1)) {
                case 12: {
                    tk = this.LT(1);
                    this.match(12);
                    gr.setTokenSection(tk.getText());
                    break;
                }
                case 7: 
                case 9: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 7: {
                    memberA = this.LT(1);
                    this.match(7);
                    gr.setMemberAction(memberA.getText());
                    break;
                }
                case 9: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            int _cnt55 = 0;
            while (true) {
                if (!_tokenSet_2.member(this.LA(1))) {
                    if (_cnt55 < 1) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    break;
                }
                this.rule(gr);
                ++_cnt55;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_3);
        }
        return gr;
    }

    public final String superClass() throws RecognitionException, TokenStreamException {
        String sup = this.LT(1).getText();
        try {
            this.match(6);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_4);
        }
        return sup;
    }

    public final void rule(Grammar gr) throws RecognitionException, TokenStreamException {
        Token r = null;
        Token arg = null;
        Token ret = null;
        Token init = null;
        Token blk = null;
        IndexedVector o = null;
        String vis = null;
        boolean bang = false;
        String eg = null;
        String thr = "";
        try {
            switch (this.LA(1)) {
                case 16: {
                    this.match(16);
                    vis = "protected";
                    break;
                }
                case 17: {
                    this.match(17);
                    vis = "private";
                    break;
                }
                case 18: {
                    this.match(18);
                    vis = "public";
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            r = this.LT(1);
            this.match(9);
            switch (this.LA(1)) {
                case 19: {
                    this.match(19);
                    bang = true;
                    break;
                }
                case 7: 
                case 13: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 20: {
                    arg = this.LT(1);
                    this.match(20);
                    break;
                }
                case 7: 
                case 13: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 21: {
                    this.match(21);
                    ret = this.LT(1);
                    this.match(20);
                    break;
                }
                case 7: 
                case 13: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 23: {
                    thr = this.throwsSpec();
                    break;
                }
                case 7: 
                case 13: 
                case 22: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 13: {
                    o = this.optionSpec(null);
                    break;
                }
                case 7: 
                case 22: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 7: {
                    init = this.LT(1);
                    this.match(7);
                    break;
                }
                case 22: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            blk = this.LT(1);
            this.match(22);
            eg = this.exceptionGroup();
            String rtext = String.valueOf(blk.getText()) + eg;
            Rule ppr = new Rule(r.getText(), rtext, o, gr);
            ppr.setThrowsSpec(thr);
            if (arg != null) {
                ppr.setArgs(arg.getText());
            }
            if (ret != null) {
                ppr.setReturnValue(ret.getText());
            }
            if (init != null) {
                ppr.setInitAction(init.getText());
            }
            if (bang) {
                ppr.setBang();
            }
            ppr.setVisibility(vis);
            if (gr != null) {
                gr.addRule(ppr);
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_5);
        }
    }

    public final String throwsSpec() throws RecognitionException, TokenStreamException {
        Token a = null;
        Token b = null;
        String t = "throws ";
        try {
            this.match(23);
            a = this.LT(1);
            this.match(9);
            t = String.valueOf(t) + a.getText();
            while (this.LA(1) == 24) {
                this.match(24);
                b = this.LT(1);
                this.match(9);
                t = String.valueOf(t) + "," + b.getText();
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_6);
        }
        return t;
    }

    public final String exceptionGroup() throws RecognitionException, TokenStreamException {
        String e = null;
        String g = "";
        try {
            while (this.LA(1) == 25) {
                e = this.exceptionSpec();
                g = String.valueOf(g) + e;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_5);
        }
        return g;
    }

    public final String exceptionSpec() throws RecognitionException, TokenStreamException {
        Token aa = null;
        String h = null;
        String es = String.valueOf(System.getProperty("line.separator")) + "exception ";
        try {
            this.match(25);
            switch (this.LA(1)) {
                case 20: {
                    aa = this.LT(1);
                    this.match(20);
                    es = String.valueOf(es) + aa.getText();
                    break;
                }
                case 1: 
                case 7: 
                case 8: 
                case 9: 
                case 16: 
                case 17: 
                case 18: 
                case 25: 
                case 26: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 26) {
                h = this.exceptionHandler();
                es = String.valueOf(es) + h;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_7);
        }
        return es;
    }

    public final String exceptionHandler() throws RecognitionException, TokenStreamException {
        Token a1 = null;
        Token a2 = null;
        String h = null;
        try {
            this.match(26);
            a1 = this.LT(1);
            this.match(20);
            a2 = this.LT(1);
            this.match(7);
            h = String.valueOf(System.getProperty("line.separator")) + "catch " + a1.getText() + " " + a2.getText();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.recover(ex, _tokenSet_8);
        }
        return h;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[2];
        lArray[0] = 2L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[2];
        lArray[0] = 4658050L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] lArray = new long[2];
        lArray[0] = 459264L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] lArray = new long[2];
        lArray[0] = 386L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] lArray = new long[2];
        lArray[0] = 2048L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] lArray = new long[2];
        lArray[0] = 459650L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] lArray = new long[2];
        lArray[0] = 4202624L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] lArray = new long[2];
        lArray[0] = 34014082L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] lArray = new long[2];
        lArray[0] = 101122946L;
        long[] data = lArray;
        return data;
    }
}

