/*
 * Decompiled with CFR 0.152.
 */
package com.javadude.antxr.scanner;

import com.javadude.antxr.CommonToken;
import com.javadude.antxr.Token;
import com.javadude.antxr.TokenStream;
import com.javadude.antxr.TokenStreamException;
import com.javadude.antxr.scanner.Attribute;
import com.javadude.antxr.scanner.BlockingQueue;
import com.javadude.antxr.scanner.XMLToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTokenStream
implements TokenStream {
    private boolean[] startTag;
    private Map namespaces = new HashMap();
    private Map tokens = new HashMap();
    private BlockingQueue blockingQueue;
    private int pcdataNum;
    private StringBuffer currentCharacters = new StringBuffer();
    private int currentCharactersLine = -1;
    private int currentCharactersColumn = -1;
    private int endTagValue;
    private int otherTagValue = -1;

    public XMLTokenStream(String[] tokenNames, Map namespaceMap, InputSource in, SAXParser parser, EntityResolver entityResolver, DTDHandler dtdHandler) {
        this(tokenNames, namespaceMap, in, parser, entityResolver, dtdHandler, -1, -1);
    }

    public XMLTokenStream(String[] tokenNames, Map namespaceMap, InputSource in, SAXParser parser, EntityResolver entityResolver, DTDHandler dtdHandler, int maximumQueueSize, int resumeQueueSize) {
        this.readTokens(tokenNames, namespaceMap);
        Integer tokenNum = (Integer)this.tokens.get("PCDATA");
        this.pcdataNum = tokenNum == null ? -99 : tokenNum;
        this.blockingQueue = new BlockingQueue(maximumQueueSize, resumeQueueSize);
        this.parse(parser, in, entityResolver, dtdHandler);
    }

    private void readTokens(String[] tokenNames, Map namespaceMap) {
        this.startTag = new boolean[tokenNames.length];
        Pattern pattern = Pattern.compile("\"<((.*):)?(.*)>\"");
        int i = 0;
        while (i < tokenNames.length) {
            String tokenName = tokenNames[i];
            Matcher matcher = pattern.matcher(tokenName);
            Integer integerValue = new Integer(i);
            if (matcher.matches()) {
                String namespace = matcher.group(2);
                String tag = matcher.group(3);
                if (namespace == null) {
                    namespace = (String)namespaceMap.get("$DEFAULT");
                }
                this.addTag(namespace, tag, integerValue);
            } else {
                this.tokens.put(tokenName, integerValue);
                if ("XML_END_TAG".equals(tokenName)) {
                    this.endTagValue = integerValue;
                }
                if ("OTHER_TAG".equals(tokenName)) {
                    this.otherTagValue = integerValue;
                }
            }
            ++i;
        }
    }

    private Integer getTokenValue(String namespace, String tag) {
        return (Integer)this.getTags(namespace).get(tag);
    }

    private void addTag(String namespace, String tag, Integer integerValue) {
        if (namespace == null) {
            namespace = "";
        }
        this.getTags(namespace).put(tag, integerValue);
        this.startTag[integerValue.intValue()] = true;
    }

    public boolean isStartTag(Token token) {
        return this.startTag[token.getType()];
    }

    private HashMap getTags(String namespace) {
        HashMap tags;
        if (namespace == null) {
            namespace = "";
        }
        if ((tags = (HashMap)this.namespaces.get(namespace)) == null) {
            tags = new HashMap();
            this.namespaces.put(namespace, tags);
        }
        return tags;
    }

    private void parse(final SAXParser parser, final InputSource in, EntityResolver entityResolver, DTDHandler dtdHandler) {
        final ANTXRXMLHandler handler = new ANTXRXMLHandler(entityResolver, dtdHandler);
        Thread saxParseThread = new Thread("saxParserCreatingXMLTokens"){

            public void run() {
                try {
                    parser.parse(in, (DefaultHandler)handler);
                }
                catch (Throwable t) {
                    XMLTokenStream.this.blockingQueue.enqueue(t);
                }
            }
        };
        saxParseThread.setDaemon(true);
        saxParseThread.start();
    }

    public Token nextToken() throws TokenStreamException {
        try {
            Object o = this.blockingQueue.dequeue();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Token)o;
        }
        catch (Throwable e) {
            throw new TokenStreamException("Error during XML parse", e);
        }
    }

    class ANTXRXMLHandler
    extends DefaultHandler {
        private Locator locator;
        private EntityResolver entityResolver;
        private DTDHandler dtdHandler;

        public ANTXRXMLHandler(EntityResolver entityResolver, DTDHandler dtdHandler) {
            this.entityResolver = entityResolver;
            this.dtdHandler = dtdHandler;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (XMLTokenStream.this.pcdataNum == -99) {
                return;
            }
            if (XMLTokenStream.this.currentCharactersLine == -1) {
                XMLTokenStream.this.currentCharactersLine = this.locator.getLineNumber();
                XMLTokenStream.this.currentCharactersColumn = this.locator.getColumnNumber();
            }
            XMLTokenStream.this.currentCharacters.append(ch, start, length);
        }

        protected void finishCharacters() {
            if (XMLTokenStream.this.pcdataNum == -99) {
                return;
            }
            int line = XMLTokenStream.this.currentCharactersLine;
            int column = XMLTokenStream.this.currentCharactersColumn;
            XMLTokenStream.this.currentCharactersLine = -1;
            XMLTokenStream.this.currentCharactersColumn = -1;
            String characters = XMLTokenStream.this.currentCharacters.toString();
            XMLTokenStream.this.currentCharacters.delete(0, XMLTokenStream.this.currentCharacters.length());
            if ("".equals(characters.trim())) {
                return;
            }
            CommonToken token = new CommonToken(XMLTokenStream.this.pcdataNum, characters);
            ((Token)token).setLine(line);
            ((Token)token).setColumn(column);
            XMLTokenStream.this.blockingQueue.enqueue(token);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.finishCharacters();
            CommonToken token = new CommonToken(XMLTokenStream.this.endTagValue, "");
            ((Token)token).setLine(this.locator.getLineNumber());
            ((Token)token).setColumn(this.locator.getColumnNumber());
            XMLTokenStream.this.blockingQueue.enqueue(token);
        }

        public void endDocument() throws SAXException {
            this.finishCharacters();
            CommonToken eofToken = new CommonToken(1, "");
            eofToken.setLine(this.locator.getLineNumber());
            eofToken.setColumn(this.locator.getColumnNumber());
            XMLTokenStream.this.blockingQueue.enqueue(eofToken);
        }

        public void error(SAXParseException e) throws SAXException {
            this.finishCharacters();
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.finishCharacters();
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            this.finishCharacters();
            throw e;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.finishCharacters();
            if ("".equals(localName)) {
                localName = qName;
            }
            XMLTokenStream.this.blockingQueue.enqueue(this.createXMLToken(uri, localName, attributes));
        }

        private XMLToken createXMLToken(String uri, String localName, Attributes attributes) throws SAXException {
            ArrayList<Attribute> attributeList;
            int tokenValue;
            Integer id = XMLTokenStream.this.getTokenValue(uri, localName);
            String name = "";
            if (uri != null && !"".equals(uri.trim())) {
                name = String.valueOf(name) + uri + ":";
            }
            name = String.valueOf(name) + localName;
            if (id != null) {
                tokenValue = id;
            } else if (XMLTokenStream.this.otherTagValue != -1) {
                tokenValue = XMLTokenStream.this.otherTagValue;
            } else {
                throw new SAXException("Tag '" + name + "' not defined in parser grammar");
            }
            if (attributes == null || attributes.getLength() == 0) {
                attributeList = Collections.EMPTY_LIST;
            } else {
                attributeList = new ArrayList<Attribute>(attributes.getLength());
                int i = 0;
                while (i < attributes.getLength()) {
                    String localAttributeName = attributes.getLocalName(i);
                    if ("".equals(localAttributeName)) {
                        localAttributeName = attributes.getQName(i);
                    }
                    String namespace = attributes.getURI(i);
                    String value = attributes.getValue(i);
                    String type = attributes.getType(i);
                    Attribute attribute = new Attribute(namespace, localAttributeName, value, type);
                    attributeList.add(attribute);
                    ++i;
                }
            }
            XMLToken token = new XMLToken(tokenValue, name, attributeList);
            token.setLine(this.locator.getLineNumber());
            token.setColumn(this.locator.getColumnNumber());
            return token;
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            if (this.dtdHandler != null) {
                this.dtdHandler.notationDecl(name, publicId, systemId);
            } else {
                super.notationDecl(name, publicId, systemId);
            }
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            if (this.dtdHandler != null) {
                this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
            } else {
                super.unparsedEntityDecl(name, publicId, systemId, notationName);
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (this.entityResolver != null) {
                try {
                    return this.entityResolver.resolveEntity(publicId, systemId);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            return super.resolveEntity(publicId, systemId);
        }
    }
}

