/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class HistorySearchViewerFilter
extends ViewerFilter {
    private final String user;
    private final String comment;
    private final Date startDate;
    private final Date endDate;
    private final boolean regExp;
    private final SVNRevision.Number startRevision;
    private final SVNRevision.Number endRevision;
    private final char CHAR_MATCH_MANY = (char)42;
    private final char CHAR_MATCH_ONE = (char)63;
    private final char CHAR_MATCH_ESCAPE = (char)92;

    public HistorySearchViewerFilter(String user, String comment, Date startDate, Date endDate, boolean regExp, SVNRevision.Number startRevision, SVNRevision.Number endRevision) {
        this.user = user;
        this.comment = comment;
        this.startDate = startDate;
        this.endDate = endDate;
        this.regExp = regExp;
        this.startRevision = startRevision;
        this.endRevision = endRevision;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ILogEntry) {
            ILogEntry logEntry = (ILogEntry)element;
            return this.filterDate(logEntry, this.startDate, this.endDate) && this.filterRevision(logEntry, this.startRevision, this.endRevision) && this.filterUser(logEntry, this.user) && this.filterComment(logEntry, this.comment);
        }
        return false;
    }

    private boolean filterUser(ILogEntry logEntry, String user) {
        if (user == null) {
            return true;
        }
        if (this.regExp) {
            return this.matchesExpression(logEntry.getAuthor(), String.valueOf(user) + '*');
        }
        return this.containsExpression(logEntry.getAuthor(), user);
    }

    private boolean filterComment(ILogEntry logEntry, String comment) {
        if (comment == null) {
            return true;
        }
        if (this.regExp) {
            return this.matchesExpression(logEntry.getComment(), String.valueOf(comment) + '*');
        }
        return this.containsExpression(logEntry.getComment(), comment);
    }

    private boolean filterDate(ILogEntry logEntry, Date startDate, Date endDate) {
        Date date = logEntry.getDate();
        if (date == null) {
            return true;
        }
        if (startDate != null && date.before(startDate)) {
            return false;
        }
        return endDate == null || !date.after(endDate);
    }

    private boolean filterRevision(ILogEntry logEntry, SVNRevision.Number startRevision, SVNRevision.Number endRevision) {
        SVNRevision.Number revision = logEntry.getRevision();
        if (revision == null) {
            return true;
        }
        if (startRevision != null && revision.getNumber() < startRevision.getNumber()) {
            return false;
        }
        return endRevision == null || revision.getNumber() <= endRevision.getNumber();
    }

    private boolean matchesExpression(String toSearch, String expression) {
        if (toSearch == null || expression == null) {
            return false;
        }
        int toSearchIndex = 0;
        int exprIndex = 0;
        while (exprIndex < expression.length() && toSearchIndex < toSearch.length()) {
            if (expression.charAt(exprIndex) == '\\') {
                if (++exprIndex == expression.length()) {
                    return false;
                }
                if (expression.charAt(exprIndex) == toSearch.charAt(toSearchIndex)) {
                    ++exprIndex;
                    ++toSearchIndex;
                    continue;
                }
                return false;
            }
            if (expression.charAt(exprIndex) == '*') {
                String partExpr = expression.substring(exprIndex + 1);
                int j = toSearchIndex;
                while (j <= toSearch.length()) {
                    if (this.matchesExpression(toSearch.substring(j), partExpr)) {
                        return true;
                    }
                    ++j;
                }
                return false;
            }
            if (expression.charAt(exprIndex) == '?') {
                return this.matchesExpression(toSearch.substring(toSearchIndex + 1), expression.substring(exprIndex + 1));
            }
            if (toSearch.charAt(toSearchIndex) == expression.charAt(exprIndex)) {
                ++toSearchIndex;
                ++exprIndex;
                continue;
            }
            return false;
        }
        int i = exprIndex;
        while (i < expression.length()) {
            if (expression.charAt(i) != '*') break;
            ++exprIndex;
            ++i;
        }
        return toSearch.length() == toSearchIndex && expression.length() == exprIndex;
    }

    private boolean containsExpression(String toSearch, String expression) {
        if (toSearch == null) {
            return false;
        }
        return toSearch.equals(expression) || toSearch.indexOf(expression) >= 0;
    }

    public SVNRevision.Number getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision.Number getEndRevision() {
        return this.endRevision;
    }
}

