/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.SVNOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShowDifferencesAsUnifiedDiffOperation
extends SVNOperation {
    private SVNUrl fromUrl;
    private SVNRevision fromRevision;
    private SVNUrl toUrl;
    private SVNRevision toRevision;
    private File file;
    private ISVNResource localResource;

    public ShowDifferencesAsUnifiedDiffOperation(IWorkbenchPart part, SVNUrl fromUrl, SVNRevision fromRevision, SVNUrl toUrl, SVNRevision toRevision, File file) {
        super(part);
        this.fromUrl = fromUrl;
        this.toUrl = toUrl;
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
        this.file = file;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws SVNException, InterruptedException {
        ISVNClientAdapter client = null;
        ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(this.fromUrl.toString());
        if (repository != null) {
            client = repository.getSVNClient();
        }
        if (client == null) {
            client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
        }
        try {
            try {
                SVNRevision pegRevision = null;
                if (this.fromUrl.toString().equals(this.toUrl.toString()) && this.localResource != null) {
                    if (this.localResource.getResource() == null) {
                        pegRevision = SVNRevision.HEAD;
                    } else {
                        IResource resource = this.localResource.getResource();
                        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                        pegRevision = svnResource.getRevision();
                    }
                }
                if (pegRevision == null) {
                    client.diff(this.fromUrl, this.fromRevision, this.toUrl, this.toRevision, this.file, true);
                } else {
                    client.diff(this.fromUrl, pegRevision, this.fromRevision, this.toRevision, this.file, true);
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        monitor.done();
    }

    protected String getTaskName() {
        return Policy.bind("HistoryView.showDifferences");
    }

    public void setLocalResource(ISVNResource localResource) {
        this.localResource = localResource;
    }
}

