/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.IColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class AntlrColorProvider
implements IColorConstants {
    private static final RGB RGB_DEFAULT = new RGB(0, 0, 0);
    private static final RGB RGB_KEYWORD = new RGB(127, 0, 85);
    private static final RGB RGB_STRING = new RGB(42, 0, 255);
    private static final RGB RGB_COMMENT = new RGB(63, 127, 95);
    private static final RGB RGB_DOC_COMMENT = new RGB(63, 95, 191);
    protected Map fColorTable = new HashMap(10);

    public static void initializeDefaults(IPreferenceStore aStore) {
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.antlr.eclipse.ui.color.default", (RGB)RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.antlr.eclipse.ui.color.keyword", (RGB)RGB_KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.antlr.eclipse.ui.color.string", (RGB)RGB_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.antlr.eclipse.ui.color.comment", (RGB)RGB_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"org.antlr.eclipse.ui.color.doc_comment", (RGB)RGB_DOC_COMMENT);
    }

    public Color getColor(String aName) {
        Color color = (Color)this.fColorTable.get(aName);
        if (color == null) {
            IPreferenceStore store = AntlrUIPlugin.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)("org.antlr.eclipse.ui.color." + aName));
            if (rgb != null) {
                color = new Color((Device)Display.getCurrent(), rgb);
            } else {
                color = Display.getCurrent().getSystemColor(24);
                AntlrUIPlugin.logErrorMessage("Undefined color '" + aName + "'");
            }
            this.fColorTable.put(aName, color);
        }
        return color;
    }

    public void dispose() {
        Iterator colors = this.fColorTable.values().iterator();
        while (colors.hasNext()) {
            ((Color)colors.next()).dispose();
        }
    }
}

