/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AntlrUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.antlr.eclipse.ui";
    private static AntlrUIPlugin plugin;
    private static final String RESOURCE_NAME = "org.antlr.eclipse.ui.messages";
    private ResourceBundle resourceBundle;

    public AntlrUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            AntlrUIPlugin.log(e);
            this.resourceBundle = null;
        }
    }

    public static AntlrUIPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = AntlrUIPlugin.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return AntlrUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return AntlrUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static URL getInstallURL() {
        return Platform.getBundle((String)PLUGIN_ID).getEntry("/");
    }

    public static String getUniqueIdentifier() {
        return Platform.getBundle((String)PLUGIN_ID).getSymbolicName();
    }

    public static void log(IStatus aStatus) {
        AntlrUIPlugin.getDefault().getLog().log(aStatus);
    }

    public static void log(Throwable aThrowable) {
        AntlrUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, AntlrUIPlugin.getMessage("Plugin.internal_error"), aThrowable));
    }

    public static void logErrorMessage(String aMessage) {
        AntlrUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, aMessage, null));
    }

    public static void logErrorStatus(String aMessage, IStatus aStatus) {
        if (aStatus == null) {
            AntlrUIPlugin.logErrorMessage(aMessage);
        } else {
            MultiStatus multi = new MultiStatus(PLUGIN_ID, 0, aMessage, null);
            multi.add(aStatus);
            AntlrUIPlugin.log((IStatus)multi);
        }
    }

    public static boolean isDebug() {
        return AntlrUIPlugin.getDefault().isDebugging();
    }

    public static String getMessage(String aKey) {
        String bundleString;
        ResourceBundle bundle = AntlrUIPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(aKey);
            }
            catch (MissingResourceException e) {
                AntlrUIPlugin.log(e);
                bundleString = "!" + aKey + "!";
            }
        } else {
            bundleString = "!" + aKey + "!";
        }
        return bundleString;
    }

    public static String getFormattedMessage(String aKey, String anArg) {
        return AntlrUIPlugin.getFormattedMessage(aKey, new String[]{anArg});
    }

    public static String getFormattedMessage(String aKey, String[] anArgs) {
        return MessageFormat.format(AntlrUIPlugin.getMessage(aKey), anArgs);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }
}

