/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class AntlrUIPluginImages {
    private static final String NAME_PREFIX = "org.antlr.eclipse.ui";
    private static final int NAME_PREFIX_LENGTH = "org.antlr.eclipse.ui".length();
    private static URL fgIconBaseURL = null;
    private static final ImageRegistry IMAGE_REGISTRY;
    public static final String IMG_OBJS_CLASS = "org.antlr.eclipse.uiclass_obj.gif";
    public static final String IMG_MISC_PUBLIC = "org.antlr.eclipse.uimethpub_obj.gif";
    public static final String IMG_MISC_PROTECTED = "org.antlr.eclipse.uimethpro_obj.gif";
    public static final String IMG_MISC_PRIVATE = "org.antlr.eclipse.uimethpri_obj.gif";
    public static final String IMG_MISC_DEFAULT = "org.antlr.eclipse.uimethdef_obj.gif";
    private static final String T_OBJ = "obj16";
    private static final String T_CTOOL = "ctool16";
    public static final ImageDescriptor DESC_OBJS_CLASS;
    public static final ImageDescriptor DESC_MISC_PUBLIC;
    public static final ImageDescriptor DESC_MISC_PROTECTED;
    public static final ImageDescriptor DESC_MISC_PRIVATE;
    public static final ImageDescriptor DESC_MISC_DEFAULT;
    public static final ImageDescriptor DESC_TOOL_SHOW_SEGMENTS;
    public static final ImageDescriptor DESC_TOOL_GOTO_NEXT_ERROR;
    public static final ImageDescriptor DESC_TOOL_GOTO_PREV_ERROR;

    static {
        Display display = Display.getCurrent();
        String pathSuffix = display != null && display.getIconDepth() > 4 ? "icons/full/" : "icons/basic/";
        try {
            fgIconBaseURL = new URL(AntlrUIPlugin.getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException e) {
            AntlrUIPlugin.log(e);
        }
        IMAGE_REGISTRY = new ImageRegistry();
        DESC_OBJS_CLASS = AntlrUIPluginImages.createManaged(T_OBJ, IMG_OBJS_CLASS);
        DESC_MISC_PUBLIC = AntlrUIPluginImages.createManaged(T_OBJ, IMG_MISC_PUBLIC);
        DESC_MISC_PROTECTED = AntlrUIPluginImages.createManaged(T_OBJ, IMG_MISC_PROTECTED);
        DESC_MISC_PRIVATE = AntlrUIPluginImages.createManaged(T_OBJ, IMG_MISC_PRIVATE);
        DESC_MISC_DEFAULT = AntlrUIPluginImages.createManaged(T_OBJ, IMG_MISC_DEFAULT);
        DESC_TOOL_SHOW_SEGMENTS = AntlrUIPluginImages.create(T_CTOOL, "segment_edit.gif");
        DESC_TOOL_GOTO_NEXT_ERROR = AntlrUIPluginImages.create(T_CTOOL, "next_error_nav.gif");
        DESC_TOOL_GOTO_PREV_ERROR = AntlrUIPluginImages.create(T_CTOOL, "prev_error_nav.gif");
    }

    public static Image get(String aKey) {
        return IMAGE_REGISTRY.get(aKey);
    }

    public static void setToolImageDescriptors(IAction anAction, String anIconName) {
        AntlrUIPluginImages.setImageDescriptors(anAction, "tool16", anIconName);
    }

    public static void setLocalImageDescriptors(IAction anAction, String anIconName) {
        AntlrUIPluginImages.setImageDescriptors(anAction, "lcl16", anIconName);
    }

    private static void setImageDescriptors(IAction anAction, String aType, String aRelPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)AntlrUIPluginImages.makeIconFileURL("d" + aType, aRelPath));
            if (id != null) {
                anAction.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            AntlrUIPlugin.log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)AntlrUIPluginImages.makeIconFileURL("c" + aType, aRelPath));
            if (id != null) {
                anAction.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            AntlrUIPlugin.log(e);
        }
        anAction.setImageDescriptor(AntlrUIPluginImages.create("e" + aType, aRelPath));
    }

    private static ImageDescriptor createManaged(String aPrefix, String aName) {
        ImageDescriptor result;
        try {
            result = ImageDescriptor.createFromURL((URL)AntlrUIPluginImages.makeIconFileURL(aPrefix, aName.substring(NAME_PREFIX_LENGTH)));
            IMAGE_REGISTRY.put(aName, result);
        }
        catch (MalformedURLException malformedURLException) {
            result = ImageDescriptor.getMissingImageDescriptor();
        }
        return result;
    }

    private static ImageDescriptor create(String aPrefix, String aName) {
        ImageDescriptor result;
        try {
            result = ImageDescriptor.createFromURL((URL)AntlrUIPluginImages.makeIconFileURL(aPrefix, aName));
        }
        catch (MalformedURLException malformedURLException) {
            result = ImageDescriptor.getMissingImageDescriptor();
        }
        return result;
    }

    private static URL makeIconFileURL(String aPrefix, String aName) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(aPrefix);
        buffer.append('/');
        buffer.append(aName);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

