/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.actions;

import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.actions.AbstractBreakpointRulerAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo info) {
        this.setInfo(info);
        this.setTextEditor(editor);
        this.setText(AntlrUIPlugin.getMessage("EnableDisableBreakpointRulerAction.&Enable_Breakpoint_1"));
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getTextEditor().getEditorSite().getShell(), (String)AntlrUIPlugin.getMessage("EnableDisableBreakpointRulerAction.Enabling/disabling_breakpoints_2"), (String)AntlrUIPlugin.getMessage("EnableDisableBreakpointRulerAction.Exceptions_occurred_enabling_disabling_the_breakpoint_3"), (IStatus)e.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean enabled = this.getBreakpoint().isEnabled();
            this.setText(enabled ? AntlrUIPlugin.getMessage("EnableDisableBreakpointRulerAction.&Disable_Breakpoint_4") : AntlrUIPlugin.getMessage("EnableDisableBreakpointRulerAction.&Enable_Breakpoint_5"));
        }
        catch (CoreException ce) {
            AntlrUIPlugin.log(ce);
        }
    }
}

