/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.actions;

import java.util.ResourceBundle;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GotoRuleAction
extends TextEditorAction {
    public GotoRuleAction(ResourceBundle aBundle, String aPrefix, ITextEditor anEditor) {
        super(aBundle, aPrefix, anEditor);
    }

    public void run() {
        AntlrEditor editor = (AntlrEditor)this.getTextEditor();
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        if (!selection.isEmpty() && selection instanceof TextSelection) {
            IDocument doc = editor.getDocument();
            int offset = selection.getOffset();
            int length = selection.getLength();
            try {
                if (length != 0) {
                    if (length < 0) {
                        length = -length;
                        offset -= length;
                    }
                    editor.gotoRule(doc.get(offset, length));
                } else {
                    int start = offset;
                    while (start > 0) {
                        if (!Character.isJavaIdentifierPart(doc.getChar(start - 1))) break;
                        --start;
                    }
                    length = offset - start;
                    int max = doc.getLength();
                    while (offset < max) {
                        if (!Character.isJavaIdentifierPart(doc.getChar(offset))) break;
                        ++offset;
                        ++length;
                    }
                    if (length > 0) {
                        editor.gotoRule(doc.get(start, length));
                    }
                }
            }
            catch (BadLocationException e) {
                AntlrUIPlugin.log(e);
            }
        }
    }
}

