/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.actions;

import org.antlr.eclipse.ui.AntlrLineBreakpointAdapter;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private AntlrLineBreakpointAdapter fAntlrLineBreakpointAdapter = new AntlrLineBreakpointAdapter();

    public ManageBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        super(AntlrUIPlugin.getMessage("ManageBreakpointRulerAction.label"));
        this.fRuler = ruler;
        this.fTextEditor = editor;
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRuler = null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    public void run() {
        try {
            IDocument document = this.getDocument();
            int lineNumber = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            if (lineNumber >= document.getNumberOfLines()) {
                return;
            }
            try {
                IRegion line = document.getLineInformation(lineNumber);
                TextSelection selection = new TextSelection(document, line.getOffset(), line.getLength());
                this.fAntlrLineBreakpointAdapter.toggleLineBreakpoints((IWorkbenchPart)this.fTextEditor, (ISelection)selection);
            }
            catch (BadLocationException badLocationException) {}
        }
        catch (CoreException e) {
            String message = AntlrUIPlugin.getMessage("ManageBreakpointRulerAction.error.adding.message1");
            AntlrUIPlugin.logErrorStatus(message, e.getStatus());
        }
    }
}

