/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.actions;

import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.AntlrUIPluginImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TogglePresentationAction
extends TextEditorAction {
    private static final String PREFIX = "Editor.TogglePresentation";

    public TogglePresentationAction() {
        super(AntlrUIPlugin.getDefault().getResourceBundle(), PREFIX, null);
        AntlrUIPluginImages.setToolImageDescriptors((IAction)this, "segment_edit.gif");
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IRegion remembered = editor.getHighlightRange();
            editor.resetHighlightRange();
            boolean showAll = !editor.showsHighlightRangeOnly();
            this.setChecked(showAll);
            this.setToolTipText(this.getToolTipText(showAll));
            editor.showHighlightRangeOnly(showAll);
            if (remembered != null) {
                editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
            }
            IPreferenceStore store = AntlrUIPlugin.getDefault().getPreferenceStore();
            store.setValue("org.antlr.eclipse.ui.editor.showSegments", showAll);
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = editor != null && editor.showsHighlightRangeOnly();
        this.setChecked(checked);
        this.setToolTipText(this.getToolTipText(checked));
        this.setEnabled(true);
    }

    public void setEditor(ITextEditor anEditor) {
        super.setEditor(anEditor);
        if (anEditor != null) {
            IPreferenceStore store = AntlrUIPlugin.getDefault().getPreferenceStore();
            boolean showSegments = store.getBoolean("org.antlr.eclipse.ui.editor.showSegments");
            if (this.isChecked() != showSegments) {
                this.setChecked(showSegments);
                this.setToolTipText(this.getToolTipText(showSegments));
            }
            if (anEditor.showsHighlightRangeOnly() != showSegments) {
                IRegion remembered = anEditor.getHighlightRange();
                anEditor.resetHighlightRange();
                anEditor.showHighlightRangeOnly(showSegments);
                if (remembered != null) {
                    anEditor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
                }
            }
        }
    }

    private String getToolTipText(boolean anIsChecked) {
        return anIsChecked ? AntlrUIPlugin.getMessage("Editor.TogglePresentation.tooltip.checked") : AntlrUIPlugin.getMessage("Editor.TogglePresentation.tooltip.unchecked");
    }
}

