/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.actions.GotoErrorAction;
import org.antlr.eclipse.ui.actions.TogglePresentationAction;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.antlr.eclipse.ui.editor.AntlrMultiPageEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class AntlrActionContributor
extends BasicTextEditorActionContributor {
    private static final String PREFIX = "Editor.";
    private static final String[] ACTIONS = new String[]{ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO, ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND, IDEActionFactory.BOOKMARK.getId(), IDEActionFactory.ADD_TASK.getId(), ITextEditorActionConstants.PRINT, ITextEditorActionConstants.REVERT};
    private SubMenuManager fSubMenuManager;
    private SubStatusLineManager fSubStatusLineManager;
    private SubToolBarManager fSubToolbarManager;
    private TogglePresentationAction fTogglePresentation;
    private GotoErrorAction fNextError;
    private GotoErrorAction fPreviousError;
    private RetargetTextEditorAction fGotoRule;
    private RetargetTextEditorAction fContentAssist;
    private RetargetTextEditorAction fComment;
    private RetargetTextEditorAction fUncomment;

    public AntlrActionContributor() {
        this.createActions();
    }

    protected void createActions() {
        this.fTogglePresentation = new TogglePresentationAction();
        this.fNextError = new GotoErrorAction(true);
        this.fPreviousError = new GotoErrorAction(false);
        this.fGotoRule = new RetargetTextEditorAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.GotoRule.");
        this.fGotoRule.setActionDefinitionId("org.antlr.eclipse.ui.edit.goto.rule");
        this.fContentAssist = new RetargetTextEditorAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.ContentAssist.");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fComment = new RetargetTextEditorAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.Comment.");
        this.fComment.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.comment");
        this.fUncomment = new RetargetTextEditorAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.Uncomment.");
        this.fUncomment.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.uncomment");
    }

    public void setActivePage(IEditorPart anEditor) {
        this.doSetActiveEditor(anEditor);
    }

    private void doSetActiveEditor(IEditorPart aPart) {
        IStatusLineManager manager = this.getActionBars().getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        AntlrEditor editor = null;
        if (aPart instanceof AntlrEditor) {
            editor = (AntlrEditor)aPart;
        }
        super.setActiveEditor((IEditorPart)editor);
        this.fSubMenuManager.setVisible(editor != null);
        this.fSubMenuManager.update(false);
        this.fSubStatusLineManager.setVisible(editor != null);
        this.fSubStatusLineManager.update(false);
        this.fSubToolbarManager.setVisible(editor != null);
        this.fSubToolbarManager.update(false);
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fNextError.setEditor((ITextEditor)editor);
        this.fPreviousError.setEditor((ITextEditor)editor);
        this.fGotoRule.setAction(this.getAction((ITextEditor)editor, "GotoRule"));
        this.fContentAssist.setAction(this.getAction((ITextEditor)editor, "ContentAssist"));
        this.fComment.setAction(this.getAction((ITextEditor)editor, "Comment"));
        this.fUncomment.setAction(this.getAction((ITextEditor)editor, "Uncomment"));
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.clearGlobalActionHandlers();
            int i = 0;
            while (i < ACTIONS.length) {
                actionBars.setGlobalActionHandler(ACTIONS[i], this.getAction((ITextEditor)editor, ACTIONS[i]));
                ++i;
            }
            actionBars.setGlobalActionHandler("GotoLine", this.getAction((ITextEditor)editor, "org.eclipse.ui.edit.text.goto.line"));
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextError);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousError);
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.comment", this.getAction((ITextEditor)editor, "Comment"));
            actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.edit.text.java.uncomment", this.getAction((ITextEditor)editor, "Uncomment"));
            actionBars.setGlobalActionHandler("org.antlr.eclipse.ui.edit.goto.rule", this.getAction((ITextEditor)editor, "GotoRule"));
            actionBars.updateActionBars();
        }
    }

    public void contributeToMenu(IMenuManager aMenuManager) {
        this.fSubMenuManager = new SubMenuManager(aMenuManager);
        super.contributeToMenu((IMenuManager)this.fSubMenuManager);
        IMenuManager menu = this.fSubMenuManager.findMenuUsingPath("edit");
        if (menu != null) {
            menu.add((IAction)this.fContentAssist);
            menu.add((IAction)this.fComment);
            menu.add((IAction)this.fUncomment);
        }
        if ((menu = this.fSubMenuManager.findMenuUsingPath("navigate")) != null) {
            menu.appendToGroup("additions", (IAction)this.fGotoRule);
        }
    }

    public void contributeToStatusLine(IStatusLineManager aStatusLineManager) {
        this.fSubStatusLineManager = new SubStatusLineManager(aStatusLineManager);
        super.contributeToStatusLine((IStatusLineManager)this.fSubStatusLineManager);
    }

    public void contributeToToolBar(IToolBarManager aToolBarManager) {
        this.fSubToolbarManager = new SubToolBarManager(aToolBarManager);
        super.contributeToToolBar((IToolBarManager)this.fSubToolbarManager);
        this.fSubToolbarManager.add((IContributionItem)new Separator());
        this.fSubToolbarManager.add((IAction)this.fTogglePresentation);
        this.fSubToolbarManager.add((IAction)this.fPreviousError);
        this.fSubToolbarManager.add((IAction)this.fNextError);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }

    public void init(IActionBars bars) {
        super.init(bars);
    }

    public void setActiveEditor(IEditorPart part) {
        IEditorPart activeNestedEditor = null;
        if (part instanceof AntlrMultiPageEditor) {
            activeNestedEditor = ((AntlrMultiPageEditor)part).getActiveEditor();
        }
        this.setActivePage(activeNestedEditor);
    }
}

