/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.antlr.eclipse.ui.editor.text.AntlrTextGuesser;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class AntlrCompletionProcessor
implements IContentAssistProcessor {
    private static final char[] AUTO_ACTIVATION_CHARS = new char[]{'(', '|', ':'};
    private AntlrEditor fEditor;
    private static final Comparator PROPOSAL_COMPARATOR = new Comparator(){

        public int compare(Object aProposal1, Object aProposal2) {
            String text1 = ((CompletionProposal)aProposal1).getDisplayString();
            String text2 = ((CompletionProposal)aProposal2).getDisplayString();
            return text1.compareTo(text2);
        }

        public boolean equals(Object aProposal) {
            return false;
        }
    };

    public AntlrCompletionProcessor(AntlrEditor anEditor) {
        this.fEditor = anEditor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer aViewer, int anOffset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        String prefix = new AntlrTextGuesser(aViewer.getDocument(), anOffset, false).getText();
        String[] rules = this.fEditor.getRules(prefix);
        int i = 0;
        while (i < rules.length) {
            if (rules[i].startsWith(prefix)) {
                proposals.add(new CompletionProposal(rules[i], anOffset - prefix.length(), prefix.length(), rules[i].length(), null, rules[i], null, null));
            }
            ++i;
        }
        Collections.sort(proposals, PROPOSAL_COMPARATOR);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return AUTO_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

