/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import java.util.ArrayList;
import org.antlr.eclipse.ui.AntlrColorProvider;
import org.antlr.eclipse.ui.editor.AntlrAnnotationHover;
import org.antlr.eclipse.ui.editor.AntlrCompletionProcessor;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.antlr.eclipse.ui.editor.AntlrTextHover;
import org.antlr.eclipse.ui.editor.EditorEnvironment;
import org.antlr.eclipse.ui.editor.text.AutoIndentStrategy;
import org.antlr.eclipse.ui.editor.text.DoubleClickStrategy;
import org.antlr.eclipse.ui.editor.text.NonRuleBasedDamagerRepairer;
import org.antlr.eclipse.ui.editor.text.PartitionScanner;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AntlrConfiguration
extends TextSourceViewerConfiguration {
    private AbstractDecoratedTextEditor fEditor;

    public AntlrConfiguration(AbstractDecoratedTextEditor anEditor) {
        this.fEditor = anEditor;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer aViewer, String aContentType) {
        return aContentType.equals("__dftl_partition_content_type") ? new AutoIndentStrategy() : new DefaultAutoIndentStrategy();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer aViewer, String aContentType) {
        return new DoubleClickStrategy();
    }

    public String[] getConfiguredContentTypes(ISourceViewer aSourceViewer) {
        return PartitionScanner.PARTITION_TYPES;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer aViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        AntlrColorProvider cp = EditorEnvironment.getColorProvider();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(EditorEnvironment.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("string")));
        reconciler.setDamager((IPresentationDamager)ndr, "__antlr_string");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__antlr_string");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("comment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__antlr_single_line_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__antlr_single_line_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("comment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__antlr_multi_line_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__antlr_multi_line_comment");
        ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(cp.getColor("doc_comment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__java_doc");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__java_doc");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer aSourceViewer) {
        MonoReconciler reconciler = this.fEditor != null && this.fEditor instanceof AntlrEditor ? new MonoReconciler((IReconcilingStrategy)((AntlrEditor)this.fEditor).getReconcilingStrategy(), false) : null;
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer aSourceViewer) {
        ContentAssistant assistant;
        if (this.fEditor != null && this.fEditor instanceof AntlrEditor) {
            assistant = new ContentAssistant();
            assistant.setContentAssistProcessor((IContentAssistProcessor)new AntlrCompletionProcessor((AntlrEditor)this.fEditor), "__dftl_partition_content_type");
            assistant.enableAutoInsert(true);
        } else {
            assistant = null;
        }
        return assistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer aSourceViewer) {
        return new AntlrAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer aSourceViewer, String aContentType) {
        AntlrTextHover hover = aContentType.equals("__dftl_partition_content_type") && this.fEditor != null && this.fEditor instanceof AntlrEditor ? new AntlrTextHover((AntlrEditor)this.fEditor) : null;
        return hover;
    }

    public String[] getDefaultPrefixes(ISourceViewer aSourceViewer, String aContentType) {
        return new String[]{"//", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        boolean useSpaces;
        String tabSize;
        ArrayList<String> prefixes = new ArrayList<String>();
        int tabWidth = 0;
        IJavaProject project = this.getProject();
        if (project != null) {
            tabSize = project.getOption("org.eclipse.jdt.core.formatter.tabulation.size", true);
            useSpaces = "space".equals(project.getOption("org.eclipse.jdt.core.formatter.tabulation.char", true));
        } else {
            tabSize = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.size");
            useSpaces = "space".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char"));
        }
        try {
            tabWidth = Integer.parseInt(tabSize);
        }
        catch (NumberFormatException numberFormatException) {
            tabWidth = 4;
        }
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            prefixes.add(prefix.toString());
            ++i;
        }
        prefixes.add("");
        return prefixes.toArray(new String[prefixes.size()]);
    }

    private IJavaProject getProject() {
        if (this.fEditor == null) {
            return null;
        }
        ICompilationUnit element = null;
        IEditorInput input = this.fEditor.getEditorInput();
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        if (provider instanceof ICompilationUnitDocumentProvider) {
            ICompilationUnitDocumentProvider cudp = (ICompilationUnitDocumentProvider)provider;
            element = cudp.getWorkingCopy((Object)input);
        } else if (input instanceof IClassFileEditorInput) {
            IClassFileEditorInput cfei = (IClassFileEditorInput)input;
            element = cfei.getClassFile();
        }
        if (element == null) {
            return null;
        }
        return element.getJavaProject();
    }
}

