/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import java.util.Iterator;
import org.antlr.eclipse.core.parser.ISegment;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.actions.GotoRuleAction;
import org.antlr.eclipse.ui.editor.AntlrConfiguration;
import org.antlr.eclipse.ui.editor.AntlrDocumentProvider;
import org.antlr.eclipse.ui.editor.AntlrMultiPageEditor;
import org.antlr.eclipse.ui.editor.AntlrReconcilingStrategy;
import org.antlr.eclipse.ui.editor.EditorEnvironment;
import org.antlr.eclipse.ui.editor.ModelTools;
import org.antlr.eclipse.ui.editor.outline.AntlrOutlinePage;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.tasklist.TaskList;

public class AntlrEditor
extends AbstractDecoratedTextEditor
implements IGotoMarker {
    private static final String PREFIX = "Editor.";
    private AntlrMultiPageEditor fMultiPageEditor;
    private ModelTools fModelTools;
    private AntlrReconcilingStrategy fReconcilingStrategy;
    private AntlrOutlinePage fOutlinePage;
    private ISelectionChangedListener fStatusLineClearer;
    private int fLastCursorLine;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AntlrEditor(AntlrMultiPageEditor aMultiPageEditor) {
        this.fMultiPageEditor = aMultiPageEditor;
        this.fModelTools = new ModelTools(this);
        this.fReconcilingStrategy = new AntlrReconcilingStrategy(this);
        this.setEditorContextMenuId("#AntlrGrammarFilePopupContext");
        this.setRulerContextMenuId("#AntlrGrammarFileRulerContext");
    }

    protected void initializeEditor() {
        super.initializeEditor();
        EditorEnvironment.connect();
        this.setDocumentProvider((IDocumentProvider)new AntlrDocumentProvider());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AntlrConfiguration(this));
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.antlr.ui.antlrEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        GotoRuleAction action = new GotoRuleAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.GotoRule.", (ITextEditor)this);
        action.setActionDefinitionId("org.antlr.eclipse.ui.edit.goto.rule");
        this.setAction("GotoRule", (IAction)action);
        action = new ContentAssistAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.ContentAssist.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)action);
        action = new TextOperationAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.comment");
        this.setAction("Comment", (IAction)action);
        action = new TextOperationAction(AntlrUIPlugin.getDefault().getResourceBundle(), "Editor.Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.uncomment");
        this.setAction("Uncomment", (IAction)action);
    }

    public Object getAdapter(Class aClass) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (aClass.equals(clazz)) {
            if (this.fOutlinePage == null || this.fOutlinePage.isDisposed()) {
                this.fOutlinePage = new AntlrOutlinePage(this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            adapter = this.fOutlinePage;
        } else {
            adapter = super.getAdapter(aClass);
        }
        return adapter;
    }

    public void dispose() {
        EditorEnvironment.disconnect();
        if (this.fOutlinePage != null && !this.fOutlinePage.isDisposed()) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        super.dispose();
    }

    protected void editorContextMenuAboutToShow(IMenuManager aMenu) {
        super.editorContextMenuAboutToShow(aMenu);
        this.addAction(aMenu, "additions", "GotoRule");
        this.addAction(aMenu, "additions", "Comment");
        this.addAction(aMenu, "additions", "Uncomment");
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        int line = this.getCursorLine();
        if (line > 0 && line != this.fLastCursorLine) {
            this.fLastCursorLine = line;
            if (this.fOutlinePage != null && !this.fOutlinePage.isDisposed()) {
                this.fOutlinePage.selectSegment(line, false);
            }
        }
    }

    public void markInNavigationHistory() {
        this.getEditorSite().getPage().getNavigationHistory().markLocation((IEditorPart)this.fMultiPageEditor);
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    public int getCursorLine() {
        int line = -1;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            StyledText styledText = sourceViewer.getTextWidget();
            int caret = AntlrEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)styledText.getCaretOffset());
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                try {
                    line = document.getLineOfOffset(caret) + 1;
                }
                catch (BadLocationException e) {
                    AntlrUIPlugin.log(e);
                }
            }
        }
        return line;
    }

    public String[] getRules(String aPrefix) {
        return this.fModelTools.getRules(aPrefix);
    }

    public ISegment getSegment(int aLine) {
        return this.fModelTools.getSegment(aLine);
    }

    public ISegment getSegment(String aName) {
        return this.fModelTools.getSegment(aName);
    }

    public void highlightSegment(ISegment aSegment, boolean aMoveCursor) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLineOffset(aSegment.getStartLine() - 1);
            IRegion endLine = doc.getLineInformation(aSegment.getEndLine() - 1);
            int length = endLine.getOffset() + endLine.getLength() - offset;
            this.setHighlightRange(offset, length, aMoveCursor);
        }
        catch (BadLocationException badLocationException) {
            this.resetHighlightRange();
        }
        this.fMultiPageEditor.activateEditor();
    }

    public void revealSegment(ISegment aSegment) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            IDocument doc = this.getDocument();
            try {
                int offset = doc.getLineOffset(aSegment.getStartLine() - 1);
                IRegion endLine = doc.getLineInformation(aSegment.getEndLine() - 1);
                int length = endLine.getOffset() + endLine.getLength() - offset;
                StyledText widget = this.getSourceViewer().getTextWidget();
                widget.setRedraw(false);
                viewer.revealRange(offset, length);
                widget.setRedraw(true);
            }
            catch (BadLocationException badLocationException) {
                this.resetHighlightRange();
            }
        }
        this.fMultiPageEditor.activateEditor();
    }

    public void gotoRule(String aName) {
        ISegment segment = this.fModelTools.getSegment(aName);
        if (segment != null) {
            this.markInNavigationHistory();
            this.highlightSegment(segment, true);
            this.markInNavigationHistory();
        }
    }

    public void gotoError(boolean anIsForward) {
        ITextSelection s;
        IMarker nextError;
        ISelectionProvider provider = this.getSelectionProvider();
        if (this.fStatusLineClearer != null) {
            provider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if ((nextError = this.getNextError((s = (ITextSelection)provider.getSelection()).getOffset(), anIsForward)) != null) {
            IWorkbenchPage page;
            IViewPart view;
            IGotoMarker gotoMarker;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((gotoMarker = (IGotoMarker)this.getAdapter(clazz)) != null) {
                gotoMarker.gotoMarker(nextError);
            }
            if ((view = (page = this.getSite().getPage()).findView("org.eclipse.ui.views.TaskList")) != null && view instanceof TaskList) {
                StructuredSelection ss = new StructuredSelection((Object)nextError);
                ((TaskList)view).setSelection((ISelection)ss, true);
            }
            this.getStatusLineManager().setErrorMessage(nextError.getAttribute("message", ""));
            this.fStatusLineClearer = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AntlrEditor.this.getSelectionProvider().removeSelectionChangedListener(AntlrEditor.this.fStatusLineClearer);
                    AntlrEditor.this.fStatusLineClearer = null;
                    AntlrEditor.this.getStatusLineManager().setErrorMessage("");
                }
            };
            provider.addSelectionChangedListener(this.fStatusLineClearer);
        } else {
            this.getStatusLineManager().setErrorMessage("");
        }
    }

    private IMarker getNextError(int anOffset, boolean anIsForward) {
        IMarker nextError = null;
        IDocument document = this.getDocument();
        int endOfDocument = document.getLength();
        int distance = 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position p;
            IMarker marker;
            Annotation a = (Annotation)iter.next();
            if (!(a instanceof MarkerAnnotation) || !MarkerUtilities.isMarkerType((IMarker)(marker = ((MarkerAnnotation)a).getMarker()), (String)"org.eclipse.core.resources.problemmarker") || (p = model.getPosition(a)).includes(anOffset)) continue;
            int currentDistance = 0;
            if (anIsForward) {
                currentDistance = p.getOffset() - anOffset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument - anOffset + p.getOffset();
                }
            } else {
                currentDistance = anOffset - p.getOffset();
                if (currentDistance < 0) {
                    currentDistance = anOffset + endOfDocument - p.getOffset();
                }
            }
            if (nextError != null && currentDistance >= distance) continue;
            distance = currentDistance;
            nextError = marker;
        }
        return nextError;
    }

    public AntlrReconcilingStrategy getReconcilingStrategy() {
        return this.fReconcilingStrategy;
    }

    public Object[] getRootElements() {
        return this.fReconcilingStrategy.getRootElements();
    }

    public ISegment getRootSegment() {
        return this.fReconcilingStrategy.getRootSegment();
    }

    public void updateOutlinePage() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void moveCursor(int aLine) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        try {
            int offset = this.getDocument().getLineOffset(aLine - 1);
            sourceViewer.setSelectedRange(offset, 0);
            sourceViewer.revealRange(offset, 0);
        }
        catch (BadLocationException e) {
            AntlrUIPlugin.log(e);
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.fMultiPageEditor.getEditorSite().getActionBarContributor();
        IStatusLineManager manager = contributor != null && contributor instanceof EditorActionBarContributor ? ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager() : null;
        return manager;
    }

    public void displayErrorMessage(String aMessage) {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(aMessage);
        }
    }
}

