/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import java.io.StringReader;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.editor.AntlrActionContributor;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.antlr.eclipse.ui.editor.AntlrNavigationLocation;
import org.antlr.eclipse.ui.editor.AntlrOverview;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AntlrMultiPageEditor
extends MultiPageEditorPart
implements INavigationLocationProvider,
IGotoMarker {
    private static final String PREFIX = "Editor.page.";
    private static final int PAGE_EDITOR = 0;
    private static final int PAGE_OVERVIEW = 1;
    private AntlrEditor fEditor;
    private AntlrOverview fOverview;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public INavigationLocation createEmptyNavigationLocation() {
        return new AntlrNavigationLocation((ITextEditor)this.fEditor, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new AntlrNavigationLocation((ITextEditor)this.fEditor, true);
    }

    public void activateEditor() {
        if (this.getActivePage() != 0) {
            this.setActivePage(0);
        }
    }

    protected void createPages() {
        try {
            this.fEditor = new AntlrEditor(this);
            this.addPage((IEditorPart)this.fEditor, this.getEditorInput());
            this.setPageText(0, AntlrUIPlugin.getMessage("Editor.page.Source"));
            this.fOverview = new AntlrOverview(this.getContainer());
            this.addPage(this.fOverview.getControl());
            this.setPageText(1, AntlrUIPlugin.getMessage("Editor.page.Overview"));
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)AntlrUIPlugin.getMessage("ErrorCreatingNestedEditor"), null, (IStatus)e.getStatus());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
    }

    protected IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public void gotoMarker(IMarker aMarker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)aMarker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof AntlrActionContributor) {
            ((AntlrActionContributor)contributor).setActivePage(activeEditor);
        }
        if (newPageIndex == 1) {
            StringReader reader = new StringReader(this.fEditor.getDocument().get());
            this.fOverview.show(reader);
        }
    }

    public boolean isDirty() {
        return this.fEditor != null && this.fEditor.isDirty();
    }

    public Object getAdapter(Class aClass) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (aClass.equals(clazz)) {
            adapter = this.fEditor.getAdapter(aClass);
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = aClass.equals(clazz2) ? this.fEditor : super.getAdapter(aClass);
        }
        return adapter;
    }

    protected void setInput(IEditorInput anInput) {
        super.setInput(anInput);
        if (anInput != null) {
            this.setPartName(anInput.getName());
            if (anInput instanceof ILocationProvider) {
                IPath path = ((ILocationProvider)anInput).getPath((Object)anInput);
                this.setContentDescription(path.removeLastSegments(1).toString());
            }
        }
    }
}

