/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import org.antlr.eclipse.core.parser.ISegment;
import org.antlr.eclipse.core.parser.Rule;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.antlr.eclipse.ui.editor.text.AntlrTextGuesser;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class AntlrTextHover
implements ITextHover {
    private AntlrEditor fEditor;

    public AntlrTextHover(AntlrEditor anEditor) {
        this.fEditor = anEditor;
    }

    public String getHoverInfo(ITextViewer aTextViewer, IRegion aRegion) {
        return this.getRule(aRegion);
    }

    public IRegion getHoverRegion(ITextViewer aTextViewer, int anOffset) {
        return new Region(anOffset, 0);
    }

    private String getRule(IRegion aRegion) {
        IDocument doc;
        AntlrTextGuesser guess;
        ISegment segment;
        if (aRegion != null && (segment = this.fEditor.getSegment((guess = new AntlrTextGuesser(doc = this.fEditor.getDocument(), aRegion.getOffset(), true)).getText())) != null && segment instanceof Rule) {
            int startLine = segment.getStartLine() - 1;
            int endLine = segment.getEndLine() - 1;
            if (endLine - startLine > 10) {
                endLine = startLine + 10;
            }
            try {
                int offset = doc.getLineOffset(startLine);
                return doc.get(offset, doc.getLineOffset(endLine) - offset + doc.getLineLength(endLine) - 1);
            }
            catch (BadLocationException e) {
                AntlrUIPlugin.log(e);
            }
        }
        return null;
    }
}

