/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import org.antlr.eclipse.ui.AntlrColorProvider;
import org.antlr.eclipse.ui.editor.outline.AntlrOutlineLabelProvider;
import org.antlr.eclipse.ui.editor.text.AntlrCodeScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.viewers.ILabelProvider;

public class EditorEnvironment {
    private static AntlrColorProvider fColorProvider;
    private static ITokenScanner fCodeScanner;
    private static ILabelProvider fLabelProvider;
    private static int fRefCount;

    static {
        fRefCount = 0;
    }

    public static void connect() {
        if (++fRefCount == 1) {
            fColorProvider = new AntlrColorProvider();
            fCodeScanner = new AntlrCodeScanner(fColorProvider);
            fLabelProvider = new AntlrOutlineLabelProvider();
        }
    }

    public static void disconnect() {
        if (--fRefCount == 0) {
            fColorProvider.dispose();
            fColorProvider = null;
            fCodeScanner = null;
            fLabelProvider.dispose();
            fLabelProvider = null;
        }
    }

    public static AntlrColorProvider getColorProvider() {
        return fColorProvider;
    }

    public static ITokenScanner getCodeScanner() {
        return fCodeScanner;
    }

    public static ILabelProvider getLabelProvider() {
        return fLabelProvider;
    }
}

