/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.antlr.eclipse.core.parser.ISegment;
import org.antlr.eclipse.core.parser.ISegmentVisitor;
import org.antlr.eclipse.core.parser.Rule;
import org.antlr.eclipse.ui.editor.AntlrEditor;

public class ModelTools {
    private AntlrEditor fEditor;

    public ModelTools(AntlrEditor anEditor) {
        this.fEditor = anEditor;
    }

    public ISegment getSegment(int aLine) {
        SegmentLineVisitor visitor = new SegmentLineVisitor(aLine);
        this.fEditor.getReconcilingStrategy().getRootSegment().accept((ISegmentVisitor)visitor);
        return visitor.getSegment();
    }

    public ISegment getSegment(String aName) {
        SegmentRuleNameVisitor visitor = new SegmentRuleNameVisitor(aName);
        this.fEditor.getReconcilingStrategy().getRootSegment().accept((ISegmentVisitor)visitor);
        return visitor.getSegment();
    }

    public String[] getRules(String aPrefix) {
        SegmentRulesVisitor visitor = new SegmentRulesVisitor(aPrefix);
        this.fEditor.getReconcilingStrategy().getRootSegment().accept((ISegmentVisitor)visitor);
        return visitor.getRules();
    }

    private class SegmentLineVisitor
    implements ISegmentVisitor {
        private int fLine;
        private ISegment fSegment;

        public SegmentLineVisitor(int aLine) {
            this.fLine = aLine;
            this.fSegment = null;
        }

        public boolean visit(ISegment aSegment) {
            boolean more;
            if (this.fLine >= aSegment.getStartLine() && this.fLine <= aSegment.getEndLine()) {
                this.fSegment = aSegment;
                more = false;
            } else {
                more = true;
            }
            return more;
        }

        public ISegment getSegment() {
            return this.fSegment;
        }
    }

    private class SegmentRulesVisitor
    implements ISegmentVisitor {
        private String fPrefix;
        private List fRules;

        public SegmentRulesVisitor(String aPrefix) {
            this.fPrefix = aPrefix;
            this.fRules = new ArrayList();
        }

        public boolean visit(ISegment aSegment) {
            String name;
            if (aSegment instanceof Rule && (name = ((Rule)aSegment).getName()).startsWith(this.fPrefix)) {
                this.fRules.add(name);
            }
            return true;
        }

        public String[] getRules() {
            return this.fRules.toArray(new String[this.fRules.size()]);
        }
    }

    private class SegmentRuleNameVisitor
    implements ISegmentVisitor {
        private String fName;
        private ISegment fSegment;

        public SegmentRuleNameVisitor(String aName) {
            this.fName = aName;
            this.fSegment = null;
        }

        public boolean visit(ISegment aSegment) {
            boolean more;
            if (aSegment instanceof Rule && ((Rule)aSegment).getName().equals(this.fName)) {
                this.fSegment = aSegment;
                more = false;
            } else {
                more = true;
            }
            return more;
        }

        public ISegment getSegment() {
            return this.fSegment;
        }
    }
}

