/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor.outline;

import org.antlr.eclipse.core.parser.ISegment;
import org.antlr.eclipse.ui.actions.CollapseAllAction;
import org.antlr.eclipse.ui.actions.LexicalSortingAction;
import org.antlr.eclipse.ui.editor.AntlrEditor;
import org.antlr.eclipse.ui.editor.outline.AntlrOutlineContentProvider;
import org.antlr.eclipse.ui.editor.outline.AntlrOutlineLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AntlrOutlinePage
extends ContentOutlinePage {
    private AntlrEditor fEditor;
    private Object fInput;
    private String fSelectedSegmentID;
    private AntlrOutlineLabelProvider fLabelProvider;
    private boolean fIsDisposed;

    public AntlrOutlinePage(AntlrEditor anEditor) {
        this.fEditor = anEditor;
        this.fIsDisposed = true;
    }

    public void createControl(Composite aParent) {
        super.createControl(aParent);
        this.fLabelProvider = new AntlrOutlineLabelProvider();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new AntlrOutlineContentProvider(this.fEditor));
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        this.fIsDisposed = false;
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add((IAction)new CollapseAllAction((AbstractTreeViewer)viewer));
        mgr.add((IAction)new LexicalSortingAction((StructuredViewer)viewer));
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent anEvent) {
        super.selectionChanged(anEvent);
        ISelection selection = anEvent.getSelection();
        if (!selection.isEmpty()) {
            ISegment segment = (ISegment)((IStructuredSelection)selection).getFirstElement();
            if (this.fSelectedSegmentID == null || this.isDifferentSegment(segment)) {
                this.fEditor.highlightSegment(segment, true);
                this.fSelectedSegmentID = segment.getUniqueID();
            } else {
                this.fEditor.revealSegment(segment);
            }
        }
    }

    public void selectSegment(int aLine, boolean aForceSelect) {
        if (aLine > 0) {
            TreeViewer viewer = this.getTreeViewer();
            ISegment segment = this.fEditor.getSegment(aLine);
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (segment == null) {
                if (this.fSelectedSegmentID != null) {
                    viewer.setSelection((ISelection)new StructuredSelection());
                    this.fEditor.resetHighlightRange();
                    this.fSelectedSegmentID = null;
                }
            } else {
                if (aForceSelect || this.isDifferentSegment(segment)) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)segment));
                    this.fEditor.highlightSegment(segment, false);
                    this.fSelectedSegmentID = segment.getUniqueID();
                }
                viewer.reveal((Object)segment);
            }
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private boolean isDifferentSegment(ISegment aSegment) {
        return this.fSelectedSegmentID == null || !this.fSelectedSegmentID.equals(aSegment.getUniqueID());
    }

    public void setInput(Object aInput) {
        this.fInput = aInput;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            control.setRedraw(true);
            this.selectSegment(this.fEditor.getCursorLine(), true);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void dispose() {
        this.setInput(null);
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        this.fIsDisposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }
}

