/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class AntlrTextGuesser {
    private String fText;
    private int fLine;

    public AntlrTextGuesser() {
        this.fText = "";
        this.fLine = -1;
    }

    public AntlrTextGuesser(IDocument aDocument, int anOffset, boolean aGuessEnd) {
        try {
            int start = anOffset;
            while (start >= 1 && AntlrTextGuesser.isWordPart(aDocument.getChar(start - 1))) {
                --start;
            }
            int end = anOffset;
            if (aGuessEnd) {
                int len = aDocument.getLength() - 1;
                while (end < len && AntlrTextGuesser.isWordPart(aDocument.getChar(end))) {
                    ++end;
                }
            }
            this.fText = aDocument.get(start, end - start);
            this.fLine = aDocument.getLineOfOffset(start) + 1;
        }
        catch (BadLocationException badLocationException) {
            this.fText = "";
            this.fLine = -1;
        }
    }

    public String getText() {
        return this.fText;
    }

    public int getLine() {
        return this.fLine;
    }

    private static final boolean isWordPart(char aChar) {
        return Character.isLetterOrDigit(aChar) || aChar == '-' || aChar == '_';
    }

    public String toString() {
        return "text=" + this.fText + ", line=" + this.fLine;
    }
}

