/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.editor.text;

import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class DoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '\"', '\"'};

    public void doubleClicked(ITextViewer aText) {
        this.fPos = aText.getSelectedRange().x;
        if (this.fPos >= 0) {
            this.fText = aText;
            if (!this.selectBracketBlock()) {
                this.selectWord();
            }
        }
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
        }
    }

    protected boolean matchBracketsAt() {
        int bracketIndex1 = BRACKETS.length;
        int bracketIndex2 = BRACKETS.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            IDocument doc = this.fText.getDocument();
            char prevChar = doc.getChar(this.fPos - 1);
            char nextChar = doc.getChar(this.fPos);
            int i = 0;
            while (i < BRACKETS.length) {
                if (prevChar == BRACKETS[i]) {
                    this.fStartPos = this.fPos - 1;
                    bracketIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < BRACKETS.length) {
                if (nextChar == BRACKETS[i]) {
                    this.fEndPos = this.fPos;
                    bracketIndex2 = i;
                }
                i += 2;
            }
            if (this.fStartPos > -1 && bracketIndex1 < bracketIndex2) {
                this.fEndPos = this.searchForClosingBracket(this.fStartPos, prevChar, BRACKETS[bracketIndex1 + 1], doc);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            } else if (this.fEndPos > -1) {
                this.fStartPos = this.searchForOpenBracket(this.fEndPos, BRACKETS[bracketIndex2 - 1], nextChar, doc);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            }
        }
        catch (BadLocationException e) {
            AntlrUIPlugin.log(e);
        }
        return false;
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = this.fPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!this.isWordPart(c)) break;
                --pos;
            }
            this.fStartPos = pos;
            pos = this.fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!this.isWordPart(c)) break;
                ++pos;
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException e) {
            AntlrUIPlugin.log(e);
            return false;
        }
    }

    protected boolean isWordPart(char aChar) {
        return Character.isLetterOrDigit(aChar) || aChar == '_';
    }

    protected int searchForClosingBracket(int aStartPosition, char anOpenBracket, char aCloseBracket, IDocument aDocument) throws BadLocationException {
        int stack = 1;
        int closePosition = aStartPosition + 1;
        int length = aDocument.getLength();
        while (closePosition < length && stack > 0) {
            char nextChar = aDocument.getChar(closePosition);
            if (nextChar == anOpenBracket && nextChar != aCloseBracket) {
                ++stack;
            } else if (nextChar == aCloseBracket) {
                --stack;
            }
            ++closePosition;
        }
        if (stack == 0) {
            return closePosition - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int stack = 1;
        int openPos = startPosition - 1;
        while (openPos >= 0 && stack > 0) {
            char nextChar = document.getChar(openPos);
            if (nextChar == closeBracket && nextChar != openBracket) {
                ++stack;
            } else if (nextChar == openBracket) {
                --stack;
            }
            --openPos;
        }
        if (stack == 0) {
            return openPos + 1;
        }
        return -1;
    }
}

