/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.ui.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.eclipse.core.AntlrCorePlugin;
import org.antlr.eclipse.core.properties.SettingsPersister;
import org.antlr.eclipse.ui.AntlrUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GrammarPropertyPage
extends PropertyPage {
    private static final String PREFIX = "Properties.Grammar.";
    private Map map;
    private Text fOutputText;
    private Text fGrammarText;
    private Map booleanControls = new HashMap();
    private Map booleanDefaults = new HashMap();

    protected Control createContents(Composite aParent) {
        Composite composite = this.setupGridLayout(new Composite(aParent, 0));
        Label note = new Label(composite, 0);
        note.setText("Note: You must recompile your grammar for these changes to take place");
        this.map = SettingsPersister.readSettings((IProject)((IResource)this.getElement()).getProject());
        AntlrCorePlugin.getDefault().upgradeOldSettings((IResource)this.getElement(), this.map);
        this.addOutputProperty(composite);
        this.addGrammarProperty(composite);
        this.addBooleanProperty(32, "cleanWarnings", this.getString("cleanWarnings.label"), composite, false);
        this.addBooleanProperty(32, "installSmap", this.getString("smap.label"), composite, true);
        this.addBooleanProperty(32, "debug", this.getString("debug.label"), composite, false);
        Group outputType = (Group)this.setupGridLayout((Composite)new Group(composite, 16));
        outputType.setText(this.getString("output.types.label"));
        this.addBooleanProperty(16, "normalOuput", this.getString("normal.label"), (Composite)outputType, true);
        this.addBooleanProperty(16, "htmlOutput", this.getString("html.label"), (Composite)outputType, false);
        this.addBooleanProperty(16, "docbookOutput", this.getString("docbook.label"), (Composite)outputType, false);
        this.addBooleanProperty(16, "diagnosticOutput", this.getString("diagnostic.label"), (Composite)outputType, false);
        Group traceType = (Group)this.setupGridLayout((Composite)new Group(composite, 16));
        traceType.setText(this.getString("trace.types.label"));
        this.addBooleanProperty(16, "noTrace", this.getString("notrace.label"), (Composite)traceType, true);
        this.addBooleanProperty(16, "trace", this.getString("trace.label"), (Composite)traceType, false);
        this.addBooleanProperty(16, "traceParser", this.getString("traceParser.label"), (Composite)traceType, false);
        this.addBooleanProperty(16, "traceLexer", this.getString("traceLexer.label"), (Composite)traceType, false);
        this.addBooleanProperty(16, "traceTreeParser", this.getString("traceTreeParser.label"), (Composite)traceType, false);
        return composite;
    }

    private Composite setupGridLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void addOutputProperty(Composite aParent) {
        Composite composite = this.createDefaultComposite(aParent);
        Label label = new Label(composite, 0);
        label.setText(this.getString("output.label"));
        this.fOutputText = new Text(composite, 2060);
        String output = SettingsPersister.get((Map)this.map, (IResource)((IResource)this.getElement()), (String)"output");
        if (output != null) {
            this.fOutputText.setText(output);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 768;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fOutputText.setLayoutData((Object)gd);
        Button button = new Button(composite, 8);
        button.setText(this.getString("output.button"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent anEvent) {
                GrammarPropertyPage.this.chooseOutputFolder();
            }

            public void widgetSelected(SelectionEvent anEvent) {
                GrammarPropertyPage.this.chooseOutputFolder();
            }
        });
    }

    private void addGrammarProperty(Composite aParent) {
        Composite composite = this.createDefaultComposite(aParent);
        Label label = new Label(composite, 0);
        label.setText(this.getString("grammar.label"));
        this.fGrammarText = new Text(composite, 2060);
        String grammar = SettingsPersister.get((Map)this.map, (IResource)((IResource)this.getElement()), (String)"superGrammars");
        if (grammar != null) {
            this.fGrammarText.setText(grammar);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 768;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fGrammarText.setLayoutData((Object)gd);
        Button button = new Button(composite, 8);
        button.setText(this.getString("grammar.button"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent anEvent) {
                GrammarPropertyPage.this.chooseGrammarFile();
            }

            public void widgetSelected(SelectionEvent anEvent) {
                GrammarPropertyPage.this.chooseGrammarFile();
            }
        });
    }

    private void addBooleanProperty(int type, String propertyName, String label, Composite aParent, boolean defaultValue) {
        boolean booleanValue;
        Button button = new Button(aParent, type);
        this.booleanControls.put(propertyName, button);
        this.booleanDefaults.put(propertyName, defaultValue);
        button.setText(label);
        String value = SettingsPersister.get((Map)this.map, (IResource)((IResource)this.getElement()), (String)propertyName);
        if (value == null) {
            booleanValue = defaultValue;
            SettingsPersister.set((Map)this.map, (IResource)((IResource)this.getElement()), (String)propertyName, (String)(defaultValue ? "true" : "false"));
        } else {
            booleanValue = "true".equalsIgnoreCase(value);
        }
        button.setSelection(booleanValue);
    }

    private Composite createDefaultComposite(Composite aParent) {
        Composite composite = new Composite(aParent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public boolean performOk() {
        SettingsPersister.set((Map)this.map, (IResource)((IResource)this.getElement()), (String)"output", (String)this.fOutputText.getText());
        SettingsPersister.set((Map)this.map, (IResource)((IResource)this.getElement()), (String)"superGrammars", (String)this.fGrammarText.getText());
        Iterator i = this.booleanControls.keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            Button b = (Button)this.booleanControls.get(propertyName);
            SettingsPersister.set((Map)this.map, (IResource)((IResource)this.getElement()), (String)propertyName, (String)String.valueOf(b.getSelection()));
        }
        SettingsPersister.writeSettings((IProject)((IResource)this.getElement()).getProject(), (Map)this.map);
        return true;
    }

    protected void performDefaults() {
        this.fOutputText.setText("");
        this.fGrammarText.setText("");
        Iterator i = this.booleanControls.keySet().iterator();
        while (i.hasNext()) {
            QualifiedName propertyName = (QualifiedName)i.next();
            Button b = (Button)this.booleanControls.get(propertyName);
            Boolean defaultValue = (Boolean)this.booleanDefaults.get(propertyName);
            b.setSelection(defaultValue.booleanValue());
        }
    }

    private String getString(String aKey) {
        return AntlrUIPlugin.getMessage(PREFIX + aKey);
    }

    private void chooseOutputFolder() {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] aSelection) {
                int i = 0;
                while (i < aSelection.length) {
                    if (!(aSelection[i] instanceof IFolder) && !(aSelection[i] instanceof IProject)) {
                        return new Status(4, AntlrUIPlugin.getUniqueIdentifier(), 0, GrammarPropertyPage.this.getString("output.choose.select"), null);
                    }
                    ++i;
                }
                return new Status(0, AntlrUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator(validator);
        dialog.setTitle(this.getString("output.choose.title"));
        dialog.setMessage(this.getString("output.choose.message"));
        dialog.addFilter((ViewerFilter)new FolderFilter());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0) {
            Object[] folders = dialog.getResult();
            String folder = folders.length > 0 ? ((IResource)folders[0]).getFullPath().toString() : "";
            this.fOutputText.setText(folder);
        }
    }

    private void chooseGrammarFile() {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] aSelection) {
                int i = 0;
                while (i < aSelection.length) {
                    if (!(aSelection[i] instanceof IFile)) {
                        return new Status(4, AntlrUIPlugin.getUniqueIdentifier(), 0, GrammarPropertyPage.this.getString("grammar.choose.select"), null);
                    }
                    ++i;
                }
                return new Status(0, AntlrUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator(validator);
        dialog.setTitle(this.getString("grammar.choose.title"));
        dialog.setMessage(this.getString("grammar.choose.message"));
        dialog.addFilter((ViewerFilter)new GrammarFileFilter());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(true);
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            StringBuffer grammars = new StringBuffer();
            int i = 0;
            while (i < files.length) {
                grammars.append(((IFile)files[i]).getFullPath().toString());
                if (i < files.length - 1) {
                    grammars.append(';');
                }
                ++i;
            }
            this.fGrammarText.setText(grammars.toString());
        }
    }

    private static class FolderFilter
    extends ViewerFilter {
        FolderFilter() {
        }

        public boolean select(Viewer aViewer, Object aParent, Object anElement) {
            return anElement instanceof IProject && ((IProject)anElement).isOpen() || anElement instanceof IFolder;
        }
    }

    private static class GrammarFileFilter
    extends ViewerFilter {
        GrammarFileFilter() {
        }

        public boolean select(Viewer aViewer, Object aParent, Object anElement) {
            String extension;
            boolean select = false;
            if (anElement instanceof IProject || anElement instanceof IFolder) {
                select = true;
            } else if (anElement instanceof IFile && (extension = ((IFile)anElement).getFileExtension()) != null && extension.equals("g")) {
                select = true;
            }
            return select;
        }
    }
}

