/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.clientadapter.svnkit;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.tigris.subversion.clientadapter.ISVNClientWrapper;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapter;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnectorFactory;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class Activator
extends Plugin
implements ISVNClientWrapper {
    public static final String PLUGIN_ID = "org.tigris.subversion.clientadapter.svnkit";
    public static final String PT_SVNCONNECTORFACTORY = "svnconnectorfactory";
    private static Activator plugin;
    private String displayName;
    private String version;
    private ISVNConnectorFactory factory = null;
    private boolean runOnce = false;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ISVNClientAdapter getAdapter() {
        if (this.isAvailable()) {
            return new SvnKitClientAdapter(null, null, this.getPluggedInSVNConnectorFactor());
        }
        return null;
    }

    public String getAdapterID() {
        return "svnkit";
    }

    public String getVersionString() {
        return this.getVersionSynchronized();
    }

    private synchronized String getVersionSynchronized() {
        if (this.version == null) {
            if (this.isAvailable()) {
                SVNClientImpl adapter = SVNClientImpl.newInstance();
                this.version = adapter.getVersion().toString();
            } else {
                this.version = "Not Available";
            }
        }
        return this.version;
    }

    public boolean isAvailable() {
        return SvnKitClientAdapterFactory.isAvailable();
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return String.valueOf(this.displayName) + " " + this.getVersionString();
    }

    public String getLoadErrors() {
        if (this.isAvailable()) {
            return "";
        }
        return "Class org.tmatesoft.svn.core.javahl.SVNClientImpl not found.\nInstall the SVNKit plug-in from http://www.svnkit.com/";
    }

    private ISVNConnectorFactory getPluggedInSVNConnectorFactor() {
        if (!this.runOnce) {
            this.runOnce = true;
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, PT_SVNCONNECTORFACTORY).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configs = extension.getConfigurationElements();
                if (configs.length == 0) {
                    Activator.log(4, NLS.bind((String)"SVNConnectorFactory {0} is missing required fields", (Object[])new Object[]{extension.getUniqueIdentifier()}), null);
                } else {
                    try {
                        IConfigurationElement config = configs[0];
                        this.factory = (ISVNConnectorFactory)config.createExecutableExtension("run");
                    }
                    catch (CoreException ex) {
                        System.err.println((Object)ex);
                        Activator.log(4, NLS.bind((String)"Could not instantiate SVNConnectorFactory for  {0}", (Object[])new Object[]{extension.getUniqueIdentifier()}), ex);
                    }
                }
                ++i;
            }
        }
        return this.factory;
    }

    public static void log(int severity, String message, Throwable e) {
        Activator.log((IStatus)new Status(severity, PLUGIN_ID, 0, message, e));
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }
}

