/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.tracker.internal;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.tigris.subversion.subclipse.tools.usage.http.IHttpGetRequest;
import org.tigris.subversion.subclipse.tools.usage.tracker.ILoggingAdapter;
import org.tigris.subversion.subclipse.tools.usage.tracker.ITracker;
import org.tigris.subversion.subclipse.tools.usage.tracker.IURLBuildingStrategy;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.IFocusPoint;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.TrackerMessages;

public class Tracker
implements ITracker {
    private IURLBuildingStrategy urlBuildingStrategy = null;
    private IHttpGetRequest httpRequest;
    private ILoggingAdapter loggingAdapter;

    public Tracker(IURLBuildingStrategy urlBuildingStrategy, IHttpGetRequest httpGetRequest, ILoggingAdapter loggingAdapter) {
        this.httpRequest = httpGetRequest;
        this.loggingAdapter = loggingAdapter;
        this.urlBuildingStrategy = urlBuildingStrategy;
    }

    public void trackSynchronously(IFocusPoint focusPoint) {
        Object[] parameters = new String[]{focusPoint.getTitle()};
        this.loggingAdapter.logMessage(MessageFormat.format(TrackerMessages.Tracker_Synchronous, parameters));
        try {
            this.httpRequest.request(this.getTrackingUrl(focusPoint));
        }
        catch (Exception e) {
            Object[] errorParameters = new String[]{e.getMessage()};
            this.loggingAdapter.logError(MessageFormat.format(TrackerMessages.Tracker_Error, errorParameters));
        }
    }

    protected String getTrackingUrl(IFocusPoint focusPoint) throws UnsupportedEncodingException {
        return this.urlBuildingStrategy.build(focusPoint);
    }

    public void trackAsynchronously(IFocusPoint focusPoint) {
        Object[] parameters = new String[]{focusPoint.getTitle()};
        this.loggingAdapter.logMessage(MessageFormat.format(TrackerMessages.Tracker_Asynchronous, parameters));
        new Thread(new TrackingRunnable(focusPoint)).start();
    }

    private class TrackingRunnable
    implements Runnable {
        private IFocusPoint focusPoint;

        private TrackingRunnable(IFocusPoint focusPoint) {
            this.focusPoint = focusPoint;
        }

        public void run() {
            try {
                Tracker.this.httpRequest.request(Tracker.this.getTrackingUrl(this.focusPoint));
            }
            catch (Exception e) {
                Object[] parameters = new String[]{e.getMessage()};
                Tracker.this.loggingAdapter.logError(MessageFormat.format(TrackerMessages.Tracker_Error, parameters));
            }
        }
    }
}

