/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.core.subscribers.DescendantResourceVariantByteStore;

public class CVSDescendantResourceVariantByteStore
extends DescendantResourceVariantByteStore {
    public CVSDescendantResourceVariantByteStore(ResourceVariantByteStore baseCache, PersistantResourceVariantByteStore remoteCache) {
        super(baseCache, (ResourceVariantByteStore)remoteCache);
    }

    protected boolean isDescendant(IResource resource, byte[] baseBytes, byte[] remoteBytes) throws TeamException {
        if (resource.getType() != 1) {
            return true;
        }
        try {
            return ResourceSyncInfo.isLaterRevisionOnSameBranch(remoteBytes, baseBytes);
        }
        catch (CVSException e) {
            throw TeamException.asTeamException((CoreException)((Object)e));
        }
    }

    public boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
        boolean changed = super.setBytes(resource, bytes);
        if (resource.getType() == 1 && this.getBytes(resource) != null && !this.parentHasSyncBytes(resource)) {
            CVSProviderPlugin.log((CoreException)((Object)new TeamException(NLS.bind((String)CVSMessages.ResourceSynchronizer_missingParentBytesOnSet, (Object[])new String[]{((PersistantResourceVariantByteStore)this.getRemoteStore()).getSyncName().toString(), resource.getFullPath().toString()}))));
        }
        return changed;
    }

    protected boolean parentHasSyncBytes(IResource resource) throws TeamException {
        if (resource.getType() == 4) {
            return true;
        }
        return this.getBytes((IResource)resource.getParent()) != null;
    }

    public boolean isVariantKnown(IResource resource) throws TeamException {
        return ((PersistantResourceVariantByteStore)this.getRemoteStore()).isVariantKnown(resource);
    }

    public IStatus handleResourceChanges(IResource[] changedResources, boolean canModifyWorkspace) {
        ArrayList<TeamException> errors = new ArrayList<TeamException>();
        int i = 0;
        while (i < changedResources.length) {
            IResource resource = changedResources[i];
            try {
                if (this.isInCVSProject(resource)) {
                    if (resource.getType() == 1 && (resource.exists() || resource.isPhantom())) {
                        byte[] remoteBytes = this.getBytes(resource);
                        if (remoteBytes == null) {
                            if (this.isVariantKnown(resource) && this.getBaseStore().getBytes(resource) != null && canModifyWorkspace) {
                                this.flushBytes(resource, 0);
                            }
                        } else {
                            byte[] localBytes = this.getBaseStore().getBytes(resource);
                            if ((localBytes == null || !this.isDescendant(resource, localBytes, remoteBytes)) && canModifyWorkspace) {
                                this.flushBytes(resource, 0);
                            }
                        }
                    } else if (resource.getType() == 2 && this.getBaseStore().getBytes(resource) != null && canModifyWorkspace) {
                        this.flushBytes(resource, 0);
                    }
                }
            }
            catch (TeamException e) {
                errors.add(e);
            }
            ++i;
        }
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            TeamException e = (TeamException)((Object)iter.next());
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return Status.OK_STATUS;
    }

    private boolean isInCVSProject(IResource resource) {
        return RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) != null;
    }
}

