/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.tmatesoft.svn.core.SVNKitActivator;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNKitLog
extends SVNDebugLogAdapter {
    private static final String DEBUG_FINE = "/debug/fine";
    private static final String DEBUG_INFO = "/debug/info";
    private static final String DEBUG_WARNING = "/debug/warning";
    private static final String DEBUG_ERROR = "/debug/error";
    private static final String DEBUG_TRACE = "/debug/trace";
    private SVNKitActivator myActivator;

    public SVNKitLog(SVNKitActivator activator) {
        this.myActivator = activator;
    }

    public boolean isFineEnabled() {
        return this.myActivator.getDebugOption(DEBUG_FINE);
    }

    public boolean isInfoEnabled() {
        return this.myActivator.getDebugOption(DEBUG_INFO);
    }

    public boolean isWarningEnabled() {
        return this.myActivator.getDebugOption(DEBUG_WARNING);
    }

    public boolean isErrorEnabled() {
        return this.myActivator.getDebugOption(DEBUG_ERROR);
    }

    public boolean isTraceEnabled() {
        return this.myActivator.getDebugOption(DEBUG_TRACE);
    }

    public InputStream createLogStream(SVNLogType logType, InputStream is) {
        if (this.isTraceEnabled()) {
            return super.createLogStream(logType, is);
        }
        return is;
    }

    public OutputStream createLogStream(SVNLogType logType, OutputStream os) {
        if (this.isTraceEnabled()) {
            return super.createLogStream(logType, os);
        }
        return os;
    }

    public void logFinest(SVNLogType logType, Throwable th) {
        this.log(logType, th, Level.FINEST);
    }

    public void logFinest(SVNLogType logType, String message) {
        this.log(logType, message, Level.FINEST);
    }

    public void logFiner(SVNLogType logType, Throwable th) {
        this.log(logType, th, Level.FINE);
    }

    public void logFiner(SVNLogType logType, String message) {
        this.log(logType, message, Level.FINE);
    }

    public void logFine(SVNLogType logType, Throwable th) {
        this.log(logType, th, Level.INFO);
    }

    public void logFine(SVNLogType logType, String message) {
        this.log(logType, message, Level.INFO);
    }

    public void logError(SVNLogType logType, String message) {
        this.log(logType, message, Level.WARNING);
    }

    public void logError(SVNLogType logType, Throwable th) {
        this.log(logType, th, Level.WARNING);
    }

    public void logSevere(SVNLogType logType, String message) {
        this.log(logType, message, Level.SEVERE);
    }

    public void logSevere(SVNLogType logType, Throwable th) {
        this.log(logType, th, Level.SEVERE);
    }

    public void log(SVNLogType logType, String message, byte[] data) {
        FrameworkLog log = this.myActivator.getFrameworkLog();
        if (log == null) {
            return;
        }
        if (this.isTraceEnabled()) {
            FrameworkLogEntry entry = null;
            String dataMessage = null;
            try {
                dataMessage = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                dataMessage = new String(data);
            }
            message = message + " : " + dataMessage;
            message = this.getMessage(logType, message);
            entry = this.myActivator.createFrameworkLogEntry(32, message, null);
            if (entry != null) {
                log.log(entry);
            }
        }
    }

    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        String message;
        FrameworkLogEntry entry;
        int level;
        FrameworkLog log = this.myActivator.getFrameworkLog();
        if (log == null) {
            return;
        }
        if (th != null && (level = this.getSeverity(logLevel)) >= 0 && (entry = this.myActivator.createFrameworkLogEntry(2, message = this.getMessage(logType, th.getMessage()), th)) != null) {
            log.log(entry);
        }
    }

    public void log(SVNLogType logType, String message, Level logLevel) {
        FrameworkLogEntry entry;
        int level;
        FrameworkLog log = this.myActivator.getFrameworkLog();
        if (log == null) {
            return;
        }
        if (message != null && (level = this.getSeverity(logLevel)) >= 0 && (entry = this.myActivator.createFrameworkLogEntry(2, message = this.getMessage(logType, message), null)) != null) {
            log.log(entry);
        }
    }

    private int getSeverity(Level logLevel) {
        int level = -1;
        if ((logLevel == Level.FINEST || logLevel == Level.FINE) && this.isFineEnabled()) {
            level = 32;
        } else if (logLevel == Level.INFO && this.isInfoEnabled()) {
            level = 32;
        } else if (logLevel == Level.WARNING && this.isWarningEnabled()) {
            level = 16;
        } else if (logLevel == Level.SEVERE && this.isErrorEnabled()) {
            level = 2;
        }
        return level;
    }

    private String getMessage(SVNLogType logType, String originalMessage) {
        if (originalMessage == null) {
            return logType.getName();
        }
        return logType.getShortName() + ": " + originalMessage;
    }
}

