/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.clientadapter.javahl;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.tigris.subversion.clientadapter.ISVNClientWrapper;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class Activator
extends Plugin
implements ISVNClientWrapper {
    public static final String PLUGIN_ID = "org.tigris.subversion.clientadapter.javahl";
    private static Activator plugin;
    private String displayName;
    private String version;
    private boolean loadErrorLogged = false;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ISVNClientAdapter getAdapter() {
        if (this.isAvailable()) {
            return new JhlClientAdapter();
        }
        return null;
    }

    public String getAdapterID() {
        return "javahl";
    }

    public String getVersionString() {
        return this.getVersionSynchronized();
    }

    private synchronized String getVersionSynchronized() {
        if (this.version == null) {
            if (this.isAvailable()) {
                JhlClientAdapter adapter = new JhlClientAdapter();
                this.version = adapter.getNativeLibraryVersionString();
            } else {
                this.version = "Not Available";
            }
        }
        return this.version;
    }

    public boolean isAvailable() {
        boolean available = JhlClientAdapterFactory.isAvailable();
        if (!available && !this.loadErrorLogged) {
            this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, this.getLoadErrors(), null));
            this.loadErrorLogged = true;
            org.tigris.subversion.clientadapter.Activator.getDefault().handleLoadErrors((ISVNClientWrapper)this);
        }
        return available;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return String.valueOf(this.displayName) + " " + this.getVersionString();
    }

    public String getLoadErrors() {
        return JhlClientAdapterFactory.getLibraryLoadErrors();
    }
}

