/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.antlr.eclipse.core.properties.SettingsPersister;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AntlrCorePlugin
extends Plugin {
    public static final String VERSION = "2.7.6";
    public static final String PLUGIN_RESOURCE_NAME = "**ANTLR-ECLIPSE-PLUGIN**";
    public static final String ANTLR_HOME = "ANTLR_HOME";
    public static final String PLUGIN_ID = "org.antlr.eclipse.core";
    public static final String SOURCE_MAPPING_MARKER = "org.antlr.eclipse.core.sourceMapMarker";
    public static final String GRAMMAR_LINE_ATTRIBUTE = "grammarLine";
    public static final String GENERATED_LINE_ATTRIBUTE = "generatedLine";
    public static final QualifiedName OLD_OUTPUT_PROPERTY;
    public static final QualifiedName OLD_SUPER_GRAMMARS_PROPERTY;
    private static AntlrCorePlugin plugin;
    private static final String RESOURCE_NAME = "org.antlr.eclipse.core.messages";
    private ResourceBundle fResourceBundle;

    static {
        System.setProperty("ANTLR_DO_NOT_EXIT", "true");
        System.setProperty("ANTLR_USE_DIRECT_CLASS_LOADING", "true");
        OLD_OUTPUT_PROPERTY = new QualifiedName(PLUGIN_ID, "AntlrOutput");
        OLD_SUPER_GRAMMARS_PROPERTY = new QualifiedName(PLUGIN_ID, "AntlrSuperGrammars");
    }

    public AntlrCorePlugin() {
        plugin = this;
        try {
            this.fResourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            AntlrCorePlugin.log(e);
            this.fResourceBundle = null;
        }
    }

    protected void createClasspathVariable(String pluginName, String variableName) {
        Bundle bundle = Platform.getBundle((String)pluginName);
        if (bundle == null) {
            JavaCore.removeClasspathVariable((String)variableName, null);
            return;
        }
        URL installLocation = bundle.getEntry("/");
        URL local = null;
        try {
            local = Platform.asLocalURL((URL)installLocation);
        }
        catch (IOException iOException) {
            JavaCore.removeClasspathVariable((String)variableName, null);
            return;
        }
        try {
            String fullPath = new File(local.getPath()).getAbsolutePath();
            JavaCore.setClasspathVariable((String)variableName, (IPath)new Path(fullPath), null);
        }
        catch (JavaModelException javaModelException) {
            JavaCore.removeClasspathVariable((String)variableName, null);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable options = JavaCore.getOptions();
        String filter = (String)options.get("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter");
        StringTokenizer st = new StringTokenizer(filter, ",");
        boolean found = false;
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("*.g")) continue;
            found = true;
            break;
        }
        if (!found) {
            if (AntlrCorePlugin.isDebug()) {
                System.out.println("Adding '*.g' to JDT builder's resource filter (" + filter + ")");
            }
            options.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", String.valueOf(filter) + ",*.g");
            JavaCore.setOptions((Hashtable)options);
        }
        this.createClasspathVariable("org.antlr", ANTLR_HOME);
    }

    public static AntlrCorePlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus aStatus) {
        AntlrCorePlugin.getDefault().getLog().log(aStatus);
    }

    public static void log(Throwable aThrowable) {
        AntlrCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, AntlrCorePlugin.getMessage("AntlrCorePlugin.internal_error"), aThrowable));
    }

    public static void logErrorMessage(String aMessage) {
        AntlrCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, aMessage, null));
    }

    public static void logErrorStatus(String aMessage, IStatus aStatus) {
        if (aStatus == null) {
            AntlrCorePlugin.logErrorMessage(aMessage);
        } else {
            MultiStatus multi = new MultiStatus(PLUGIN_ID, 0, aMessage, null);
            multi.add(aStatus);
            AntlrCorePlugin.log((IStatus)multi);
        }
    }

    public static boolean isDebug() {
        return AntlrCorePlugin.getDefault().isDebugging();
    }

    public static boolean isDebug(String anOption) {
        String value;
        boolean debug = AntlrCorePlugin.isDebug() ? (value = Platform.getDebugOption((String)anOption)) != null && value.equalsIgnoreCase("true") : false;
        return debug;
    }

    public static String getMessage(String aKey) {
        String bundleString;
        ResourceBundle bundle = AntlrCorePlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(aKey);
            }
            catch (MissingResourceException e) {
                AntlrCorePlugin.log(e);
                bundleString = "!" + aKey + "!";
            }
        } else {
            bundleString = "!" + aKey + "!";
        }
        return bundleString;
    }

    public static String getFormattedMessage(String aKey, String anArg) {
        return AntlrCorePlugin.getFormattedMessage(aKey, new String[]{anArg});
    }

    public static String getFormattedMessage(String aKey, String[] anArgs) {
        return MessageFormat.format(AntlrCorePlugin.getMessage(aKey), anArgs);
    }

    public void upgradeOldSettings(IResource resource, Map map) {
        String oldValue;
        boolean upgraded = false;
        try {
            oldValue = resource.getPersistentProperty(OLD_OUTPUT_PROPERTY);
            resource.setPersistentProperty(OLD_OUTPUT_PROPERTY, null);
            if (oldValue != null) {
                upgraded = true;
                SettingsPersister.set(map, resource, "output", oldValue);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            oldValue = resource.getPersistentProperty(OLD_SUPER_GRAMMARS_PROPERTY);
            resource.setPersistentProperty(OLD_SUPER_GRAMMARS_PROPERTY, null);
            if (oldValue != null) {
                upgraded = true;
                SettingsPersister.set(map, resource, "superGrammars", oldValue);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!VERSION.equals(SettingsPersister.get(map, "pluginVersion"))) {
            upgraded = true;
            SettingsPersister.set(map, "pluginVersion", VERSION);
        }
        if (upgraded) {
            SettingsPersister.writeSettings(resource.getProject(), map);
        }
    }
}

