/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.antlr.eclipse.core.AntlrCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class AntlrNature
implements IProjectNature {
    public static final String ID = "org.antlr.eclipse.core.antlrnature";
    public static final String DEBUG_OPTION = "org.antlr.eclipse.core/nature/debug";
    public static boolean DEBUG = false;
    private IProject fProject;

    public AntlrNature() {
        DEBUG = AntlrCorePlugin.isDebug(DEBUG_OPTION);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject aProject) {
        this.fProject = aProject;
    }

    public void configure() throws CoreException {
        if (DEBUG) {
            System.out.println("configuring ANTLR nature");
        }
        IProject project = this.getProject();
        IProjectDescription projectDescription = project.getDescription();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(projectDescription.getBuildSpec()));
        ICommand antlrBuilderCommand = projectDescription.newCommand();
        antlrBuilderCommand.setBuilderName("org.antlr.eclipse.core.antlrbuilder");
        ICommand warningCleanerBuilderCommand = projectDescription.newCommand();
        warningCleanerBuilderCommand.setBuilderName("org.antlr.eclipse.core.warningcleanerbuilder");
        ICommand smapBuilderCommand = projectDescription.newCommand();
        smapBuilderCommand.setBuilderName("org.antlr.eclipse.core.smapbuilder");
        if (!commands.contains(antlrBuilderCommand)) {
            commands.add(0, antlrBuilderCommand);
        }
        if (!commands.contains(warningCleanerBuilderCommand)) {
            commands.add(warningCleanerBuilderCommand);
        }
        if (!commands.contains(smapBuilderCommand)) {
            commands.add(smapBuilderCommand);
        }
        projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        this.getProject().setDescription(projectDescription, null);
    }

    public void deconfigure() throws CoreException {
        if (DEBUG) {
            System.out.println("deconfiguring ANTLR nature");
        }
        IProject project = this.getProject();
        IProjectDescription desc = project.getDescription();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(desc.getBuildSpec()));
        Iterator i = commands.iterator();
        while (i.hasNext()) {
            ICommand command = (ICommand)i.next();
            if (!command.getBuilderName().equals("org.antlr.eclipse.core.antlrbuilder") && !command.getBuilderName().equals("org.antlr.eclipse.core.smapbuilder") && !command.getBuilderName().equals("org.antlr.eclipse.core.warningcleanerbuilder")) continue;
            i.remove();
        }
        desc.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.setDescription(desc, null);
    }

    public static void addNature(IProject aProject, IProgressMonitor aMonitor) {
        if (aProject != null) {
            if (DEBUG) {
                System.out.println("adding ANTLR nature to project '" + aProject.getName() + "'");
            }
            try {
                if (!aProject.hasNature(ID)) {
                    IProjectDescription desc = aProject.getDescription();
                    ArrayList<String> natures = new ArrayList<String>(Arrays.asList(desc.getNatureIds()));
                    natures.add(0, ID);
                    desc.setNatureIds(natures.toArray(new String[natures.size()]));
                    aProject.setDescription(desc, aMonitor);
                    if (aProject.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)aProject);
                        ArrayList<IClasspathEntry> rawClasspath = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                        boolean hasAntlrJar = false;
                        Iterator i = rawClasspath.iterator();
                        while (i.hasNext()) {
                            String segment0;
                            IClasspathEntry entry = (IClasspathEntry)i.next();
                            if (entry.getEntryKind() != 4 || !"ANTLR_HOME".equals(segment0 = entry.getPath().segment(0))) continue;
                            hasAntlrJar = true;
                            break;
                        }
                        if (!hasAntlrJar) {
                            rawClasspath.add(JavaCore.newVariableEntry((IPath)new Path("ANTLR_HOME/antlr.jar"), (IPath)new Path("ANTLR_HOME/antlrsrc.zip"), null));
                        }
                        if (!hasAntlrJar) {
                            javaProject.setRawClasspath(rawClasspath.toArray(new IClasspathEntry[rawClasspath.size()]), null);
                        }
                    }
                }
            }
            catch (CoreException e) {
                AntlrCorePlugin.log(e);
            }
        }
    }

    public static void removeNature(IProject aProject, IProgressMonitor aMonitor) {
        if (aProject != null) {
            if (DEBUG) {
                System.out.println("removing ANTLR nature from project '" + aProject.getName() + "'");
            }
            try {
                if (aProject.hasNature(ID)) {
                    IProjectDescription desc = aProject.getDescription();
                    ArrayList<String> natures = new ArrayList<String>(Arrays.asList(desc.getNatureIds()));
                    natures.remove(ID);
                    desc.setNatureIds(natures.toArray(new String[natures.size()]));
                    aProject.setDescription(desc, aMonitor);
                    if (aProject.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)aProject);
                        ArrayList<IClasspathEntry> rawClasspath = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                        boolean hadAntlrJar = false;
                        Iterator i = rawClasspath.iterator();
                        while (i.hasNext()) {
                            IClasspathEntry entry = (IClasspathEntry)i.next();
                            if (entry.getEntryKind() != 4) continue;
                            String segment0 = entry.getPath().segment(0);
                            if ("ANTLR_HOME".equals(segment0)) {
                                i.remove();
                                hadAntlrJar = true;
                            }
                            if (!"PARSEVIEW_HOME".equals(segment0)) continue;
                            i.remove();
                            hadAntlrJar = true;
                        }
                        if (hadAntlrJar) {
                            javaProject.setRawClasspath(rawClasspath.toArray(new IClasspathEntry[rawClasspath.size()]), null);
                        }
                    }
                }
            }
            catch (CoreException e) {
                AntlrCorePlugin.log(e);
            }
        }
    }

    public static boolean hasNature(IProject aProject) {
        boolean hasNature;
        try {
            hasNature = aProject.hasNature(ID);
        }
        catch (CoreException e) {
            AntlrCorePlugin.log(e);
            hasNature = false;
        }
        return hasNature;
    }
}

